﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/hid/system/hid_FirmwareUpdate.h>

#include "../sgx/gui/SimpleGfx_Gui.h"

namespace nns { namespace hid { namespace ui {

/**
 * @brief   ファームウェア更新中の進捗表示ダイアログを扱うクラスです。
 */
class FirmwareUpdateProgressDialog final :
    public nns::sgx::gui::Dialog
{
    NN_DISALLOW_COPY(FirmwareUpdateProgressDialog);
    NN_DISALLOW_MOVE(FirmwareUpdateProgressDialog);

public:
    FirmwareUpdateProgressDialog() NN_NOEXCEPT;

    virtual ~FirmwareUpdateProgressDialog() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Initialize() NN_NOEXCEPT NN_OVERRIDE;

    virtual void Disappear() NN_NOEXCEPT NN_OVERRIDE;

    void StartProgressCheck(
        const nn::hid::system::UniquePadId& id,
        const nn::hid::system::FirmwareUpdateDeviceHandle& handle) NN_NOEXCEPT;

    bool IsFinished() const NN_NOEXCEPT;

    bool IsSucceeded() const NN_NOEXCEPT;

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

private:
    static void RenderHandler(NNS_SGX_GUI_EVENT_HANDLER_ARGS(pSender, arg)) NN_NOEXCEPT;

    void RenderImpl() NN_NOEXCEPT;

    void DrawProgressBar(float x, float y) NN_NOEXCEPT;

private:
    bool                                        m_IsProcessing;
    nns::sgx::gui::WaitIcon                     m_WaitIcon;
    nns::sgx::ImageData                         m_ProgressBarImage;
    int                                         m_Progress;
    int                                         m_ProgressAnimCount;
    int                                         m_ControllerNumber;
    nn::hid::system::UniquePadType              m_PadType;
    nn::hid::system::FirmwareUpdateDeviceHandle m_DeviceHandle;
    nn::Result                                  m_UpdateResult;
};

}}}  // nns::hid::ui
