﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "../sgx/gui/SimpleGfx_Gui.h"
#include "../util/FirmwareImage.h"

namespace nns { namespace hid { namespace ui {

/**
 * @brief   ファームウェアイメージの詳細情報を表示するクラスです。
 */
class FirmwareInfoView final :
    public nns::sgx::gui::Canvas
{
    NN_DISALLOW_COPY(FirmwareInfoView);
    NN_DISALLOW_MOVE(FirmwareInfoView);

public:
    FirmwareInfoView() NN_NOEXCEPT;

    void SetImage(const util::FirmwareImage* pImage) NN_NOEXCEPT;

    void Appear() NN_NOEXCEPT;

    void Disappear() NN_NOEXCEPT;

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

private:
    enum class AnimationType
    {
        None,
        Appear,
        Disappear
    };

private:
    virtual void RenderContents() NN_NOEXCEPT NN_OVERRIDE;

    bool IsAnimating() const NN_NOEXCEPT
    {
        return m_CurrentAnimation != AnimationType::None;
    }

    void UpdateAnimation() NN_NOEXCEPT;

    void ForceFinishAnimation() NN_NOEXCEPT;

private:
    const util::FirmwareImage*  m_pImage;
    int                         m_AnimDuration;
    AnimationType               m_CurrentAnimation;
    float                       m_OriginX;
};

}}}  // nns::hid::ui
