﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommon.h"
#include "SimpleGfx_GuiLabel.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   処理中を示すウェイトアイコンを扱うクラスです。
 */
class WaitIcon :
    public Label
{
    NN_DISALLOW_COPY(WaitIcon);
    NN_DISALLOW_MOVE(WaitIcon);

public:
    WaitIcon() NN_NOEXCEPT;

    virtual void Update() NN_NOEXCEPT NN_OVERRIDE;

private:
    int m_Duration;     //!< アイコン更新用のカウンタ
    int m_Interval;     //!< アイコンの更新間隔
};

}}}  // nns::sgx::gui
