﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>

#include "../SimpleGfx_Types.h"
#include "SimpleGfx_GuiCommon.h"

namespace nns { namespace sgx { namespace gui {

/**
 * @brief   カーソルの繋がりを定義する型です。
 */
class CursorLink
{
    NN_DISALLOW_COPY(CursorLink);
    NN_DISALLOW_MOVE(CursorLink);

public:
    CursorLink() NN_NOEXCEPT;

    /**
     * @brief   指定した方向に対して、カーソル移動先のリンクを張ります。
     */
    void SetLink(Direction dir, DisplayObject* pObject) NN_NOEXCEPT;

private:
    Direction       m_Direction;
    DisplayObject*  m_pLinkObject;
};

}}}  // nns::sgx::gui
