﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Assert.h>
#include <nn/nn_Log.h>
#include <nn/os.h>

#include "SimpleGfx_Api.h"

namespace nns { namespace sgx {

/**
 * @brief   オブジェクト解放インターフェース
 */
class IDisposable
{
public:
    /**
     * @brief   オブジェクトが解放済みか判定します。
     */
    virtual bool IsDisposed() const NN_NOEXCEPT = 0;

    /**
     * @brief   オブジェクトを開放します。
     */
    virtual void Dispose() NN_NOEXCEPT = 0;
};

/**
 * @brief   画像
 */
class Image : public IDisposable
{
    NN_DISALLOW_COPY(Image);
    NN_DISALLOW_MOVE(Image);
public:
    Image() NN_NOEXCEPT :
        m_ImageData()
    {}

    virtual ~Image() NN_NOEXCEPT
    {
        Dispose();
    }

    virtual bool IsDisposed() const NN_NOEXCEPT NN_OVERRIDE
    {
        return m_ImageData.pPixelData == nullptr;
    }

    virtual void Dispose() NN_NOEXCEPT NN_OVERRIDE
    {
        if (m_ImageData.pPixelData != nullptr)
        {
            DestroyImage(&m_ImageData);
        }
    }

private:
    ImageData   m_ImageData;
};

}}  // nns::sgx
