﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <vector>
#include <mutex>

#include <nn/nn_Log.h>
#include <nn/nn_SdkAssert.h>
#include <nn/oe/oe_HomeButtonControl.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs.h>
#include <nn/hid/debug/hid_FirmwareUpdate.h>
#include <nn/hid/hid_Npad.h>
#include <nn/hid/hid_NpadJoy.h>
#include <nn/hid/hid_Result.h>
#include <nn/hid/hid_ResultPrivate.h>
#include <nn/hid/system/hid_Result.h>
#include <nn/hid/system/hid_UniquePad.h>
#include <nn/time.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_StringUtil.h>

#include "input/Input.h"
#include "scene/SceneManager.h"
#include "scene/FlashWriter.h"
#include "sgx/SimpleGfx.h"
#include "sgx/SimpleGfx_PostEffect.h"
#include "util/util.h"

namespace {

// 初期シーン
nns::hid::scene::FlashWriter g_InitialScene;

}  // anonymous namespace

extern "C" void nnMain()
{
    nn::time::Initialize();
    nns::hid::util::InitializeFileSystem();

    {
        // FS は独自に初期化している
        auto param = nns::sgx::InitializationParameters::CreateDefault();
        param.isInitializeFs = false;
        nns::sgx::Initialize(param);
        nns::sgx::InitializePostEffect();

        nns::sgx::SetClearColor(nns::hid::util::BackgroundColor);
    }

    input::Initialize();
    nns::hid::scene::SceneManager::Initialize();

    // StringTable の読み込み
    {
        auto& str = nns::hid::util::StringTable::GetInstance();
        NN_ABORT_UNLESS_EQUAL(
            str.Open("rom:/StringTable.json"),
            nns::hid::util::JsonResult::Success
        );

        // 言語切り替え
        str.SetLanguage(nns::hid::util::Config::GetLanguage());
        //str.SetLanguage(nns::hid::util::Language::English);
    }

    nns::hid::scene::SceneManager::Push(&g_InitialScene);

    while (!nns::hid::scene::SceneManager::IsExitRequested())
    {
        input::Update();
        nns::hid::scene::SceneManager::StepFrame();
    }

    nn::oe::EndBlockingHomeButton();  // 念のため

    nns::hid::util::StringTable::GetInstance().Close();
    nns::hid::scene::SceneManager::Finalize();

    nns::sgx::FinalizePostEffect();
    nns::sgx::Finalize();
    nns::hid::util::FinalizeFileSystem();
    nn::time::Finalize();
}
