﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "layout_SeekBar.h"

namespace nns { namespace hidfw { namespace layout {

    SeekBar::SeekBar() NN_NOEXCEPT
    {
        SetDefault();
    }

    void SeekBar::SetDefault() NN_NOEXCEPT
    {
        m_Margin = nn::util::MakeFloat2(8.f, 24.f);
        static_cast<BaseItem*>(this)->SetDefault();
        SetSize(320.f, 16.f);

        m_BorderColor       = nn::util::Color4u8( 96,  96,  96, 255);   // ボーダーを濃い灰色に
        m_MainColor         = nn::util::Color4u8( 38, 224,  62, 255);   // メインのゲージ色
        m_SubColor          = nn::util::Color4u8(255,   0,   0, 128);   // ゲージに加算する色
        m_BaseColor         = nn::util::Color4u8( 48,  48,  64, 230);   // ゲージ背面色
        m_BarColor          = nn::util::Color4u8(212, 212, 212, 255);   // 操作バーの色

        m_BarSize           = 16.f;
        m_BarPos            = 0.f;
        m_MaxValue          = 100;
        m_Value             = 50;
        m_TextTransparence  = 0.f;
        m_ValueShowCount    = 0;
    }

    void SeekBar::Update() NN_NOEXCEPT
    {
        ++m_FrameCount;

        auto oldValue = m_Value;

        m_ConvPos = nn::util::MakeFloat2(m_Pos.x + m_Margin.x, m_Pos.y + m_Margin.y);
        m_ConvSize = nn::util::MakeFloat2(m_Size.x - m_Margin.x * 2.f, m_Size.y - m_Margin.y * 2.f);

        if (m_Value > m_MaxValue) { m_Value = m_MaxValue; }

        nn::util::Float2 nearPos = NN_UTIL_FLOAT_2_INITIALIZER(m_ConvPos.x + m_ConvSize.x / 2.f, m_ConvPos.y + m_ConvSize.y / 2.f);
        nn::hid::TouchState state;

        if (gTouch.GetTouchState(&state, nearPos))
        {
            if ((state.x > m_Pos.x && state.x - m_Pos.x < m_Size.x) &&
                (state.y > m_Pos.y && state.y - m_Pos.y < m_Size.y))
            {
                if (gTouch.IsEnable(m_Pos, m_Size) && IsEnableAutoShowValue())
                {
                    ShowValue(120);
                }
                if (m_ConvSize.x > 1)
                {
                    m_Value = ((std::max(static_cast<float>(state.x), m_ConvPos.x) - m_ConvPos.x) / m_ConvSize.x) * static_cast<float>(m_MaxValue) + 0.5f;
                }
                else
                {
                    m_Value = 0;
                }
            }
        }

        if (
            (m_Option.Test<LayoutOption::ThroughChoose>() && m_State.Test<LayoutState::Hover>()) ||
            (!m_Option.Test<LayoutOption::ThroughChoose>() && m_State.Test<LayoutState::Selected>())
            )
        {
            if (m_State.Test<LayoutState::Selected>())
            {
                m_Option.Set<LayoutOption::ThroughChoose>();
            }
            else
            {
                m_Option.Reset<LayoutOption::ThroughChoose>();
            }
            for (
                std::vector<nns::hidfw::hid::Controller*>::iterator it = gController.GetConnectedControllerList().begin();
                it != gController.GetConnectedControllerList().end();
                ++it
                )
            {
                // デジタルキーは小刻みな調整に利用し、最優先で処理します
                if ((*it)->IsHold(nn::hid::NpadButton::Left::Mask | nn::hid::NpadButton::Right::Mask))
                {
                    if ((*it)->IsHold(nn::hid::NpadButton::Left::Mask))
                    {
                        if ((*it)->IsRepeat(nn::hid::NpadButton::Left::Mask))
                        {
                            SubValue(1);
                        }
                    }
                    else
                    {
                        if ((*it)->IsRepeat(nn::hid::NpadButton::Right::Mask))
                        {
                            AddValue(1);
                        }
                    }
                    if (IsEnableAutoShowValue()) { ShowValue(120); }
                    break;
                }
                else
                {
                    if ((*it)->IsHold(nn::hid::NpadButton::StickLLeft::Mask | nn::hid::NpadButton::StickRLeft::Mask))
                    {
                        SubValue(1);
                        if (IsEnableAutoShowValue()) { ShowValue(120); }
                        break;
                    }
                    else if ((*it)->IsHold(nn::hid::NpadButton::StickLRight::Mask | nn::hid::NpadButton::StickRRight::Mask))
                    {
                        AddValue(1);
                        if (IsEnableAutoShowValue()) { ShowValue(120); }
                        break;
                    }
                }
            }
        }

        if (m_State.Test<LayoutState::Selected>() && !m_State.Test<LayoutState::OnFocus>() && !m_State.Test<LayoutState::Hover>())
        {
            m_State.Reset<LayoutState::Selected>();
            m_Option.Reset<LayoutOption::ThroughChoose>();
        }

        if (IsEnableShowValue())
        {
            m_TextTransparence = std::min(static_cast<float>(m_ValueShowCount - m_FrameCount) / 60.f, 0.8f);
        }
        else
        {
            m_TextTransparence = 0.f;
        }

        if (m_Value > m_MaxValue) { m_Value = m_MaxValue; }
        (m_MaxValue == 0) ? m_BarPos = 0.f : m_BarPos = (static_cast<float>(m_Value) / static_cast<float>(m_MaxValue));

        if (oldValue != m_Value) { CallFunc(); }
    }

    void SeekBar::PrintText() NN_NOEXCEPT
    {
        if (IsEnableShowValue())
        {
            SetText("%d / %d", m_Value, m_MaxValue);
            m_TextTransparence = m_TextTransparence - std::floorf(m_TextTransparence);
            gTextWriter.SetTextColor(nn::util::Color4u8(m_TextColor.GetR(), m_TextColor.GetG(), m_TextColor.GetB(), static_cast<uint8_t>(m_TextColor.GetA() * m_TextTransparence)));
            gTextWriter.SetScale(m_Scale.x, m_Scale.y);

            m_TextAreaSize = nn::util::MakeFloat2(
                gTextWriter.CalculateStringWidth(m_Text.c_str()) + 32.f,
                gTextWriter.CalculateStringHeight(m_Text.c_str()) + 32.f);

            m_TextAreaPos = nn::util::MakeFloat2(
                m_ConvPos.x + (m_BarPos * m_ConvSize.x)  - (m_TextAreaSize.x / 2.f),
                (m_ConvPos.y - m_TextAreaSize.y > m_Margin.y) ?
                m_ConvPos.y - m_TextAreaSize.y - m_Margin.y :
                m_ConvPos.y + m_ConvSize.y + m_Margin.y
            );

            const nn::util::Float2 textPos = nn::util::MakeFloat2(
                m_TextAreaPos.x + 16.f,
                m_TextAreaPos.y + 16.f);

            gTextWriter.SetCursor(textPos.x, textPos.y);
            gTextWriter.Print("%s", m_Text.c_str());
        }
    }

    void SeekBar::Draw() NN_NOEXCEPT
    {
        const nn::util::Color4u8 transparenceBorderColor = nn::util::Color4u8(m_BorderColor.GetR(), m_BorderColor.GetG(), m_BorderColor.GetB(), 0);
        //const nn::util::Color4u8 transparenceSubColor = nn::util::Color4u8(m_SubColor.GetR(), m_SubColor.GetG(), m_SubColor.GetB(), 0);

        const nn::util::Color4u8 shadowBaseColor = nn::util::Color4u8(8, 8, 10, 255);
        const nn::util::Color4u8 shadowMainColor = nn::util::Color4u8(169, 120, 80, 255); //nn::util::Color4u8(16, 140, 32, 255);
        const nn::util::Color4u8 shadowBarColor = nn::util::Color4u8(160, 172, 192, 255);

        const float barWidth = m_BarPos * (m_ConvSize.x - m_BarSize);
        const float barDrawPos = m_ConvPos.x + barWidth;

        if (m_State.Test<LayoutState::Hover>())
        {
            // ホバー時のエフェクトの色
            const nn::util::Color4u8 transparenceEffectColor = nn::util::Color4u8(m_EffectColor.v[0], m_EffectColor.v[1], m_EffectColor.v[2], 0);
            float effect = nn::util::SinEst(nn::util::DegreeToRadian((m_FrameCount % 120) * 3)) * 1.f + 5.f;
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_EffectColor, transparenceEffectColor);
            gDrawer.Draw2DRoundedFrame(nn::util::MakeFloat2(m_ConvPos.x, m_ConvPos.y), nn::util::MakeFloat2(m_ConvSize.x, m_ConvSize.y), 1.f, 24, effect);
        }

        // 下地
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_BorderColor, transparenceBorderColor);
        gDrawer.Draw2DRoundedFrame(m_ConvPos, m_ConvSize, 1.f, 24, 1.5f);
        gDrawer.Draw2DRoundedFrame(m_ConvPos, m_ConvSize, 1.f, 24, 1.5f);
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, shadowBaseColor,m_BaseColor);
        gDrawer.Draw2DRoundedRect(m_ConvPos,m_ConvSize, 1.f, 24);
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_MainColor, shadowMainColor);
        gDrawer.Draw2DRoundedRect(m_ConvPos, nn::util::MakeFloat2(barWidth + m_BarSize, m_ConvSize.y), 1.f, 24);
        //gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Right, m_SubColor, transparenceSubColor);
        //gDrawer.Draw2DRoundedRect(m_ConvPos, nn::util::MakeFloat2(barWidth + m_BarSize, m_ConvSize.y), 1.f, 24);
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_BorderColor, transparenceBorderColor);
        gDrawer.Draw2DRoundedFrame(m_ConvPos, m_ConvSize, 1.f, 24, -1.f);

        // 操作部 (バー)
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_BorderColor, transparenceBorderColor);
        gDrawer.Draw2DRoundedFrame(nn::util::MakeFloat2(barDrawPos, (m_ConvPos.y - 8.f)), nn::util::MakeFloat2(16, (m_ConvSize.y + 16.f)), 0.8f, 32, 1.5f);
        gDrawer.Draw2DRoundedFrame(nn::util::MakeFloat2(barDrawPos, (m_ConvPos.y - 8.f)), nn::util::MakeFloat2(16, (m_ConvSize.y + 16.f)), 0.8f, 32, 1.5f);
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_BarColor, shadowBarColor);
        gDrawer.Draw2DRoundedRect(nn::util::MakeFloat2(barDrawPos, (m_ConvPos.y - 8.f)), nn::util::MakeFloat2(16, (m_ConvSize.y + 16.f)), 0.8f, 32);
        gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, m_BorderColor, transparenceBorderColor);
        gDrawer.Draw2DRoundedFrame(nn::util::MakeFloat2(barDrawPos, (m_ConvPos.y - 8.f)), nn::util::MakeFloat2(16, (m_ConvSize.y + 16.f)), 0.8f, 32, -1.f);

        if (IsEnableShowValue())
        {
            // 値の描画が必要な場合バーより後に描画処理を実行します
            gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down,
                nn::util::Color4u8(255, 255, 255, static_cast<uint8_t>(m_TextColor.GetA() * m_TextTransparence)),
                nn::util::Color4u8(255, 255, 255, 0));
            gDrawer.Draw2DRoundedFrame(m_TextAreaPos, m_TextAreaSize, 0.5f, 48, 3.f);
            gDrawer.SetColor(nn::util::Color4u8(255, 255, 255, static_cast<uint8_t>(m_TextColor.GetA() * m_TextTransparence)));
            gDrawer.Draw2DRoundedRect(m_TextAreaPos, m_TextAreaSize, 0.5f, 48);
        }
    }

    void SeekBar::ShowValue(uint64_t showCount) NN_NOEXCEPT
    {
        m_ValueShowCount = m_FrameCount + showCount;
    }

}}}
