﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       図や線、テキスト描画関連処理を総合的に管理するAPIの宣言
 * @details     本ヘッダのインクルードで、図や線、テキスト描画が全て可能になります
 */

#pragma once

#include <cstdlib>
#include "gfx/gfx_GraphicsSystem.h"
#include "gfx/gfx_GraphicsDrawer.h"

namespace nns { namespace hidfw { namespace gfx {

    /**
     * @brief       図や線、テキスト描画関連処理を総合的に管理するクラスです
     * @details     インスタンスの生成、初期化、各種描画システムの有効化を行います
     */
    class Graphics
    {
        NN_DISALLOW_COPY(Graphics);
        NN_DISALLOW_MOVE(Graphics);
    public:
        static Graphics& GetInstance() NN_NOEXCEPT;
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;
        nns::hidfw::gfx::GraphicsDrawer& GetDrawer() NN_NOEXCEPT;
        nns::hidfw::gfx::GraphicsSystem& GetGraphicsSystem() NN_NOEXCEPT;
        nn::gfx::util::DebugFontTextWriter& GetTextWriter() NN_NOEXCEPT;

        nn::mem::StandardAllocator* GetApplicationHeap() NN_NOEXCEPT { return &m_AppAllocator; }

    public:
        static const size_t AppMemorySize;

    private:
        //----------------------------------------------------------------
        //! @brief GetInstance の内部で呼び出されます
        //----------------------------------------------------------------
        Graphics() NN_NOEXCEPT;

    private:
        nns::hidfw::gfx::GraphicsSystem m_GraphicsSystem;
        nn::Bit8*                       m_pAppMemory;
        nn::mem::StandardAllocator      m_AppAllocator;
    };

}}}

#define gGraphics (nns::hidfw::gfx::Graphics::GetInstance())
#define gDrawer (nns::hidfw::gfx::GraphicsDrawer::GetInstance())
#define gTextWriter (nns::hidfw::gfx::Graphics::GetInstance().GetTextWriter())
