﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
  Graphics 機能のサンプルです
*/

#include "hidfw/gfx.h"

namespace GraphicsSample
{
    extern "C" void nnMain()
    {
        uint64_t frameCount = 0;
        gGraphics.Initialize();             // グラフィックスの初期化を行います

        gGraphics.GetGraphicsSystem().SetEnablePerfMeter(true);

        //======================================================================
        // メインループ
        //======================================================================
        do
        {
            gGraphics.GetGraphicsSystem().BeginPerfFrame();                 // パフォーマンスの計測開始

            nn::util::Float2 pos = NN_UTIL_FLOAT_2_INITIALIZER(0.f, 0.f);   // 描画座標

            gDrawer.BeginDraw();                                            // 描画関数の受付開始
            {
                pos = nn::util::MakeFloat2(50.f, 100.f);

                gDrawer.SetColor(nn::util::Color4u8::Red());
                gDrawer.Draw2DRect(pos, nn::util::MakeFloat2(100, 100));                            // 赤色の矩形
                pos.x += 200.f;
                gDrawer.SetColor(nn::util::Color4u8::Blue());
                gDrawer.Draw2DRoundedRect(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48);           // 青色の角が丸い矩形
                pos.x += 200.f;
                gDrawer.SetColor(nn::util::Color4u8::White());
                gDrawer.Draw2DScreenShot(pos, nn::util::MakeFloat2(100, 100));                      // ScreenShot() 実行時の画面
                pos.x += 200.f;
                gDrawer.SetColor(nn::util::Color4u8::Yellow());
                gDrawer.Draw2DCircle(nn::util::MakeFloat2(pos.x + 50.f, pos.y + 50.f), 50.f, 48.f); // 黄色い円形
                pos.x += 200.f;
                gDrawer.SetColor(nn::util::Color4u8::Green());
                gDrawer.Draw2DFrame(pos, nn::util::MakeFloat2(100, 100), 5.f);                      // 緑色の枠
                pos.x += 200.f;
                gDrawer.SetColor(nn::util::Color4u8::Magenta());
                gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48, 5.f);     // マゼンタ色の角が丸い枠

                gDrawer.SetColor(nn::util::Color4u8::Gray());
                gDrawer.Draw2DLine(nn::util::MakeFloat2(50, 250), nn::util::MakeFloat2(1230, 250)); // 灰色の線分

                pos = nn::util::MakeFloat2(50.f, 300.f);

                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_None, nn::util::Color4u8::Red(), nn::util::Color4u8::Yellow());   // グラデーションをかけない
                gDrawer.Draw2DRoundedRect(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48);
                pos.x += 200.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Left, nn::util::Color4u8::Red(), nn::util::Color4u8::Yellow());   // 左方向にグラデーションをかける
                gDrawer.Draw2DRoundedRect(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48);
                pos.x += 200.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Up, nn::util::Color4u8::Red(), nn::util::Color4u8::Yellow());     // 上方向にグラデーションをかける
                gDrawer.Draw2DRoundedRect(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48);
                pos.x += 200.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Right, nn::util::Color4u8::Red(), nn::util::Color4u8::Yellow());  // 右方向にグラデーションをかける
                gDrawer.Draw2DRoundedRect(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48);
                pos.x += 200.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8::Red(), nn::util::Color4u8::Yellow());   // 下方向にグラデーションをかける
                gDrawer.Draw2DRoundedRect(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48);
                pos.x += 200.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Left, nn::util::Color4u8::Yellow(), nn::util::Color4u8::Red());   // 円形に対し左方向にグラデーションをかける
                gDrawer.Draw2DCircle(nn::util::MakeFloat2(pos.x + 50.f, pos.y + 50.f), 50.f, 8, (float)(frameCount % 360));                     // 円形の分割数を減らし、8角形を描画します。また1フレーム舞に1度分時計周りに回転させます

                nn::util::Float2 lineList[11];
                for (size_t i = 0; i < NN_ARRAY_SIZE(lineList); ++i)
                {
                    lineList[i] = nn::util::MakeFloat2(i * 118 + 50, 450 + nn::util::SinEst(nn::util::DegreeToRadian(i * 90)) * 25.f);          // ジグザグの線分
                }
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8::Green(), nn::util::Color4u8::Magenta());// 始点から終点方向へグラデーションをかけます
                gDrawer.Draw2DLine(NN_ARRAY_SIZE(lineList), lineList);

                pos = nn::util::MakeFloat2(50.f, 500.f);

                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_None, nn::util::Color4u8::Red(), nn::util::Color4u8::Yellow());   // 矩形の外周部から外向きに5px分の幅を持つ枠
                gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48, 5.f);
                pos.x += 200.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8::Red(), nn::util::Color4u8::Yellow());   // グラデーションつきの枠
                gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48, 5.f);
                pos.x += 200.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8::Red(), nn::util::Color4u8::Yellow());   // 矩形外周部から内向きに5px分の幅を持つグラデーションつきの枠
                gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48, -5.f);
                pos.x += 200.f;
                if (frameCount % 120 < 60)
                {
                    gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8::Green(), nn::util::Color4u8::Black());
                    gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 1.f, 48, 1.5f);                                             // 正方形かつ丸みを1.fかつ分割数が4の倍数の角が丸い矩形は、円形のように表示されます
                }
                gDrawer.SetColor(nn::util::Color4u8::Green());
                gDrawer.Draw2DCircle(nn::util::MakeFloat2(pos.x + 50.f, pos.y + 50.f), 50.f, 48);                                               // グラデーションで擬似的なジャギ消しを表現します
                pos.x += 200.f;
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8::Red(), nn::util::Color4u8::Black());    // 枠線の内側と外側に擬似的なジャギ消しを施します
                gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48, 1.5f);                                                            // 本サンプルでは背景が黒いであるため 緑→黒 のグラデーションで表現していますが
                gDrawer.SetColor(nns::hidfw::gfx::GraphicsDrawer::GradationDirection_Down, nn::util::Color4u8::Red(), nn::util::Color4u8::Black());    // SetColorの第二引数の色情報の透明度成分を0にした色へグラデーションをかけた場合にも近い表現が可能です
                gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48, -1.5f);                                                           // 例) (255, 0, 0, 255) → (255, 0, 0, 0)
                pos.x += 200.f;
                gDrawer.SetColor(nn::util::Color4u8::Red());
                gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48, 1.5f);                                                // 擬似的なジャギ消しを行っていない比較用の矩形
                gDrawer.Draw2DRoundedFrame(pos, nn::util::MakeFloat2(100, 100), 0.5f, 48, -1.5f);

                /*
                 *  現在の画面内用を保存します
                 */
                gDrawer.ScreenShot();
            }
            gDrawer.EndDraw();              // 描画終了
            ++frameCount;
            gGraphics.GetGraphicsSystem().EndPerfFrame();
        } while (frameCount < 60 * 100);     // 100 秒で終了します

        gGraphics.Finalize();               // 確保していたリソースを開放します

    }
} // NOLINT(readability/fn_size)
