﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdlib>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/os/os_Argument.h>
#include <nn/os/os_Thread.h>
#include <nn/nn_TimeSpan.h>

extern "C" void nndiagStartup();

// アプリ専用の SDK モジュール初期化ルーチンを無効にするためのダミー関数定義。
// Initialize-Sdev-Raw.ps1 の最後で DevMenu と HelloWorld の２つのアプリが
// 同時に起動してしまい、いずれかが FG メッセージ無限待ちになるのを防ぐため。
extern "C" void nninitInitializeSdkModule()
{
    nndiagStartup();
}

extern "C" void nninitFinalizeSdkModule()
{
}

extern "C" void nnMain()
{
    auto argc = nn::os::GetHostArgc();
    auto argv = nn::os::GetHostArgv();

    auto loopNum = argc > 1 ? std::atoi(argv[1]) : 100;

    for(int i=0; i<loopNum; i++)
    {
        NN_LOG("Hello, world. %d/%d\n", i, loopNum);
        nn::os::SleepThread(nn::TimeSpan::FromSeconds(1));
    }

    NN_LOG("Hello, world. %d/%d ... Exit.\n", loopNum, loopNum);

    return;
}
