﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once
#include "DevQuestMenu_ModeSceneCommon.h"

namespace nn { namespace devquestmenu {

    /**
     * @brief       アプリケーション更新モード
     */
    class ApplicationUpdateModeScene : public ModeSceneCommon
    {
    public:
        explicit ApplicationUpdateModeScene(RootSurfaceContext* pRootSurface) NN_NOEXCEPT;

        ~ApplicationUpdateModeScene() NN_NOEXCEPT;

        void OnLoop() NN_NOEXCEPT NN_OVERRIDE;

        ModeType DetermineNextMode(const DisplayModeTime& displayModeTime) NN_NOEXCEPT NN_OVERRIDE;

        ModeType GetSuccessNextMode() NN_NOEXCEPT NN_OVERRIDE;

    private:

        void InitializeView() NN_NOEXCEPT;


        bool m_IsApplicationUpdateDone = false;                                 //! アプリケーション更新が終了したかどうかの判定
        Result m_ApplicationUpdateResult;                                       //! アプリケーション更新結果
        nn::rid::ApplicationUpdater m_ApplicationUpdater;                       //! rid アプリケーションアップデータ
        nn::os::ThreadType m_UpdateExecutionThread;                             //! アップデート実行スレッド

        //! 描画オブジェクトの位置
        glv::Rect m_ProgressSliderRect = { m_GridWidth * 11.2f, m_GridHeight * 9, m_GridWidth * 4.6f, m_GridHeight * 2 };
        glv::Label::Spec m_StatusLabelSpec = { glv::Place::TL, m_GridWidth * 11.2f, m_GridHeight * 7, 25.f };

        //! 描画オブジェクト
        std::unique_ptr<glv::Label> m_ApplicationUpdateStatus;                   //! 更新状況のラベル
        std::unique_ptr<glv::Slider> m_ApplicationUpdateProgress;                //! 更新の Progress バー
    };
}}

