﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include "DevQuestMenu_TextureView.h"

namespace nn { namespace devquestmenu {

    TextureView::TextureView(const glv::Rect& r) NN_NOEXCEPT
        : View(r), m_Tex(256, 256, GL_RGB, GL_UNSIGNED_BYTE)
    {
        this->disable(glv::Property::FocusToTop | glv::Property::HitTest);

        // Generate a pattern for the texture...
        unsigned char * pPixels = m_Tex.buffer< unsigned char >();
        for (int j = 0; j < m_Tex.height(); ++j)
        {
            for (int i = 0; i < m_Tex.width(); ++i)
            {
                int k = j * m_Tex.width() + i;
                pPixels[k * 3] = i * 13 ^ j * 3;
                pPixels[k * 3 + 1] = i * 1 ^ j * 2;
                pPixels[k * 3 + 2] = 0;
            }
        }
        m_Tex.magFilter(GL_NEAREST);
    }

    bool TextureView::onEvent(glv::Event::t e, glv::GLV& g) NN_NOEXCEPT
    {
        switch (e) {
        case glv::Event::WindowCreate:
            m_Tex.recreate();                // Create texture on GPU
            m_Tex.send();                    // Send over texel data
            break;
        case glv::Event::WindowDestroy:
            m_Tex.destroy();                 // Destroy texture on GPU
            break;
        default:
            break;
        }
        return true;
    }

    void TextureView::onDraw(glv::GLV& g) NN_NOEXCEPT
    {
        glv::draw::enable(glv::draw::Texture2D);    // Enable texture mapping
        m_Tex.begin();                              // Bind texture
        glv::draw::color(1, 1, 1, 1);               // Set current color
        m_Tex.draw(0, 0, width(), height());        // Draw a textured quad filling the view's area
        m_Tex.end();                                // Unbind texture
        glv::draw::disable(glv::draw::Texture2D);   // Disable texture mapping
    }
}}
