﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../ui_IMenuItem.h"

namespace ui{ namespace util{

    class MenuItemGeometry
    {
    public:
        static Position GetGlobalPosition(const std::shared_ptr<const IMenuItem>& p) NN_NOEXCEPT
        {
            if(p == nullptr)
            {
                return {};
            }

            Position pos = p->GetLayoutPosition();
            return GetGlobalPosition(p->GetParentInfo().pParent.lock()) + pos;
        }

        static Rectangle GetGlobalRectangle(const std::shared_ptr<const IMenuItem>& p) NN_NOEXCEPT
        {
            if(p == nullptr)
            {
                return {};
            }

            Size size = p->GetLayoutSize();
            return { GetGlobalPosition(p), size };
        }

    };

}}
