﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <functional>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "ui_RadioButtonGroup.h"

namespace ui{
    class IMenuPage;

    class RadioButton
        : public std::enable_shared_from_this<RadioButton>
    {
        friend class RadioButtonGroup;
    public:

        // コールバック関数は呼び出されない。
        explicit RadioButton(const std::shared_ptr<RadioButtonGroup>& pGroup) NN_NOEXCEPT;

        // コールバック関数は呼び出されない。
        ~RadioButton() NN_NOEXCEPT;

        // このラジオボタンが所属しているグループを取得する。
        std::shared_ptr<RadioButtonGroup> GetGroup() NN_NOEXCEPT;

        // このラジオボタンの選択状態が変化した際に呼ばれるコールバックを設定する。
        // @return this
        std::shared_ptr<RadioButton> SetValueChangedCallbackFunction(const std::function<void (bool, const std::shared_ptr<IMenuPage>&)>& function) NN_NOEXCEPT;

        // このラジオボタンが選択されているかを取得する。
        bool IsSelected() const NN_NOEXCEPT;

        // このラジオボタンの選択状態を変更する。
        // 選択状態が変化した場合、 ValueChangedCallbackFunction が呼び出される。
        // @param[in] value このラジオボタンを選択状態にする場合 true, このラジオボタンを非選択状態にする場合 false。
        void SetSelected(bool value, const std::shared_ptr<IMenuPage>&) NN_NOEXCEPT;

    private:
        // RadioButtonGroup から呼ばれる
        void NotifySelectedStateChanged(bool value, const std::shared_ptr<IMenuPage>&) NN_NOEXCEPT;

    private:
        std::shared_ptr<RadioButtonGroup> m_pGroup;
        std::function<void (bool, const std::shared_ptr<IMenuPage>&)> m_ValueChangedCallbackFunction;
    };

}
