﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../../Config.h"
#include "../ui_Macro.h"
#include "../ui_IMenuItem.h"
#include "../ui_IMenuPage.h"
#include "../ui_StyleTypes.h"

namespace ui{ namespace base{

    template<typename TBaseType, typename TConcreteType>
    class MenuItemBase
        : public TBaseType
        , public std::enable_shared_from_this<TConcreteType>
    {
    public:
        typedef TBaseType BaseType;
        typedef TConcreteType ConcreteType;

    public:

    //@name Structure
    //@{
    public:
        virtual std::string GetName() const NN_NOEXCEPT UI_FINAL
        {
            return m_Name;
        }

        virtual void SetName(const std::string& value) NN_NOEXCEPT UI_FINAL
        {
            m_Name = value;
        }

        virtual void OnParentItemChanged(const std::shared_ptr<IMenuItem>& pNewParent, size_t indexOnParent) NN_NOEXCEPT UI_FINAL
        {
            m_ParentInfo.pParent = pNewParent;
            m_ParentInfo.index   = indexOnParent;
        }

        virtual MenuItemParentInfo GetParentInfo() const NN_NOEXCEPT UI_FINAL
        {
            return m_ParentInfo;
        }

    //@}

    //@name Geometry
    //@{
    public:
        virtual Position GetLayoutPosition() const NN_NOEXCEPT UI_FINAL
        {
            return m_LayoutPosition;
        }

        virtual void SetLayoutPosition(const Position& value) NN_NOEXCEPT UI_FINAL
        {
            m_LayoutPosition = value;
        }

        virtual Size GetLayoutSize() const NN_NOEXCEPT UI_FINAL
        {
            return m_LayoutSize;
        }

        //virtual void UpdateLayoutRecursively(const MenuLayoutUpdateContext& context) NN_NOEXCEPT = 0;

        // この関数は LayoutSize の中で呼び出すこと。
        void SetLayoutSize(const Size& value) NN_NOEXCEPT
        {
            m_LayoutSize = value;
        }

    //@}

    //@name Enablity
    //@{
    public:
        virtual bool IsEnabled() const NN_NOEXCEPT UI_FINAL
        {
            return m_IsEnabled;
        }

        virtual void SetEnablity(bool isEnabled) NN_NOEXCEPT UI_FINAL
        {
            m_IsEnabled = isEnabled;
        }
    //@}

    //@name Focus
    //@{
    public:
        //virtual bool IsFocusAcceptable() const NN_NOEXCEPT NN_OVERRIDE = 0

        virtual void OnInFocus()  NN_NOEXCEPT NN_OVERRIDE
        {
        }

        virtual void OnOutFocus() NN_NOEXCEPT NN_OVERRIDE
        {
        }

        virtual void NotifyFocusedItemChanged(const MenuFocusedItemChangedContext&) NN_NOEXCEPT NN_OVERRIDE
        {
        }

    //@}

    //@name Touch
    //@{
    public:
        //virtual bool IsTouchAcceptable() const NN_NOEXCEPT NN_OVERRIDE = 0

    //@}

    //@name User Input
    //@{
    public:

        virtual MenuButtonResult HandlePositiveButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleNegativeButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleUpButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleDownButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleLeftButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleRightButtonPressed(const MenuButtonHandleContext& context) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleLeftAnalogStickInput(const MenuButtonHandleContext& context, const nn::util::Vector3f& value) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleRightAnalogStickInput(const MenuButtonHandleContext& context, const nn::util::Vector3f& value) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleTouched(const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleTouchDown(const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleTouchUp(const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleTouchMove(const MenuButtonHandleContext& context, const nn::util::Vector3f& position) NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

        virtual MenuButtonResult HandleTouchCanceled() NN_NOEXCEPT NN_OVERRIDE
        {
            return MenuButtonResult::GetNotHandled();
        }

    //@}

    //@name Load/Store Value
    //@{
    public:
        virtual void LoadValue(const std::shared_ptr<IMenuPage>&) NN_NOEXCEPT NN_OVERRIDE
        {
        }

        virtual void StoreValue() const NN_NOEXCEPT NN_OVERRIDE
        {
        }

    //@}

    //@name Rendering
    //@{
    public:
        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT NN_OVERRIDE
        {
            return nullptr;
        }

        virtual void UpdatePanel() NN_NOEXCEPT NN_OVERRIDE
        {
        }

    //@}


    protected:
        std::string m_Name = {};
        MenuItemParentInfo m_ParentInfo = {};

        bool m_IsEnabled = true;
        Position m_LayoutPosition = {0, 0};
        Size     m_LayoutSize     = {0, 0};
    };

}}
