﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <list>
#include <nn/nn_Common.h>
#include "../../panel/panel_PanelContainer.h"

#include "../Scene.h"
#include "NotificationSlot.h"
#include "NotificationAudioVolume.h"

#include "../../RunMode.h"
#include "../../ThreadMessageChannel.h"

namespace scene{ namespace overlay{

    class SceneOverlayParameter
    {
    public:
        explicit SceneOverlayParameter(
            ThreadMessageChannel* pOverlayNotificationChannel,
            nn::os::MultiWaitType* pSceneEventMultiWait,
            RunMode* pRunMode
        ) NN_NOEXCEPT
            : m_pOverlayNotificationChannel(pOverlayNotificationChannel)
            , m_pSceneEventMultiWait(pSceneEventMultiWait)
            , m_pRunMode(pRunMode)
        {
        }

        ThreadMessageChannel* GetOverlayNotificationChannel() const NN_NOEXCEPT
        {
            return m_pOverlayNotificationChannel;
        }

        nn::os::MultiWaitType* GetSceneEventMultiWait() const NN_NOEXCEPT
        {
            return m_pSceneEventMultiWait;
        }

        RunMode* GetRunMode() const NN_NOEXCEPT
        {
            return m_pRunMode;
        }

    private:
        ThreadMessageChannel* m_pOverlayNotificationChannel;
        nn::os::MultiWaitType* m_pSceneEventMultiWait;
        RunMode* m_pRunMode;

    };

    class SceneOverlay
        : public Scene
    {
    public:
        explicit SceneOverlay(const std::shared_ptr<void>& pArg) NN_NOEXCEPT;
        virtual SceneUpdateResult Update() NN_NOEXCEPT NN_OVERRIDE;
        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT NN_OVERRIDE;

    private:
        void PushReactionNotification(const std::shared_ptr<INotification>& pNotification, nn::os::Tick currentTick) NN_NOEXCEPT;
        // コンディション通知をキューに積む。
        void PushConditionNotification(const std::shared_ptr<INotification>& pNotification, nn::os::Tick currentTick) NN_NOEXCEPT;
        // キューの先頭のコンディション通知を表示する。
        void PresentConditionNotification(nn::os::Tick currentTick) NN_NOEXCEPT;

    private:
        ThreadMessageChannel* m_pOvlnChannel;
        nn::os::MultiWaitType* m_pSceneEventMultiWait;
        RunMode* m_pRunMode;
        NotificationSlot m_ConditionNotificationSlot;
        NotificationSlot m_ReactionNotificationSlot;
        std::shared_ptr<panel::PanelContainer> m_pPanelContainer;

        std::list<std::shared_ptr<INotification>> m_ConditionNotificationQueue;
    };

}}
