﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationControllerPairing.h"

#include <nn/util/util_FormatString.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationControllerPairing::NotificationControllerPairing() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetControllerPairingTextColor());
        m_pPanel->SetTextPosition(Style::GetControllerPairingTextPositionX(), Style::GetControllerPairingTextPositionY());
        m_pPanel->SetTextSize(Style::GetControllerPairingTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationControllerPairing::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationControllerPairing::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationControllerPairing::Setup(nn::hid::system::NpadDeviceTypeSet deviceType) NN_NOEXCEPT
    {
        typedef nn::hid::system::NpadDeviceType DeviceType;
        if(deviceType.Test<DeviceType::HandheldJoyLeft>() || deviceType.Test<DeviceType::JoyConLeft>())
        {
            m_pPanel->SetText("Joy-Con (L) Registered");
        }
        else if(deviceType.Test<DeviceType::HandheldJoyRight>() || deviceType.Test<DeviceType::JoyConRight>())
        {
            m_pPanel->SetText("Joy-Con (R) Registered");
        }
        else
        {
            m_pPanel->SetText("Controller Registered");
        }

        m_TimeToLive = config::NotificationTtl::GetTtlControllerPairing();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_ControllerPairing;
        return true;
    }

}}
