﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/hid/system/hid_NpadCommon.h>

#include "INotification.h"
#include "NotificationBase.h"
#include "../../panel/panel_PanelText.h"

#include "ConvertControllerInfo.h"

namespace scene{ namespace overlay{

    class NotificationControllerBattery
        : public NotificationBase
    {
    public:
        NotificationControllerBattery() NN_NOEXCEPT;

        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT NN_OVERRIDE;
        virtual void ReadyToAppear() NN_NOEXCEPT NN_OVERRIDE;

        bool SetupLowBattery(ControllerType controllerType) NN_NOEXCEPT;
        bool SetupNoBattery(ControllerType controllerType) NN_NOEXCEPT;

    public:
        std::shared_ptr<panel::PanelText> m_pPanel;
    };

}}
