﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "NotificationControllerBattery.h"

#include <nn/util/util_FormatString.h>
#include "../../config/NotificationParameter.h"

namespace scene{ namespace overlay{

    NotificationControllerBattery::NotificationControllerBattery() NN_NOEXCEPT
    {
        typedef config::NotificationStyle Style;

        m_pPanel = std::make_shared<panel::PanelText>();
        m_pPanel->SetPosition(nn::util::Vector3f(0, 0, 0));
        m_pPanel->SetSize(Style::GetSizeF());
        m_pPanel->SetColor(Style::GetBackgroundColor());
        m_pPanel->SetVisibility(panel::PanelVisibility::Visible);

        m_pPanel->SetTextColor(Style::GetControllerBatteryTextColor());
        m_pPanel->SetTextPosition(Style::GetControllerBatteryTextPositionX(), Style::GetControllerBatteryTextPositionY());
        m_pPanel->SetTextSize(Style::GetControllerBatteryTextSize());
    }

    std::shared_ptr<panel::IPanel> NotificationControllerBattery::GetPanel() NN_NOEXCEPT
    {
        return m_pPanel;
    }

    void NotificationControllerBattery::ReadyToAppear() NN_NOEXCEPT
    {
    }

    bool NotificationControllerBattery::SetupLowBattery(ControllerType type) NN_NOEXCEPT
    {
        const char* pMessage = "";
        switch(type)
        {
        case ControllerType_JoyDualLeft:
        case ControllerType_JoyConLeftVertical:
        case ControllerType_JoyConLeftHorizontal:
        case ControllerType_HandheldLeft:
            pMessage = "Joy-Con (L) Low Battery";
            break;
        case ControllerType_JoyDualRight:
        case ControllerType_JoyConRightVertical:
        case ControllerType_JoyConRightHorizontal:
        case ControllerType_HandheldRight:
            pMessage = "Joy-Con (R) Low Battery";
            break;
        case ControllerType_JoyDualBoth:
        case ControllerType_HandheldBoth:
            pMessage = "Joy-Con (L)&(R) Low Battery";
            break;
        case ControllerType_FullKeyController:
            pMessage = "FullKeyController Low Battery";
            break;
        default:
            pMessage = "Controller Low Battery";
            break;
        }
        m_pPanel->SetText(pMessage);

        m_TimeToLive = config::NotificationTtl::GetTtlControllerLowBattery();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_ControllerLowBattery;
        return true;
    }

    bool NotificationControllerBattery::SetupNoBattery(ControllerType type) NN_NOEXCEPT
    {
        const char* pMessage = "";
        switch(type)
        {
        case ControllerType_JoyDualLeft:
        case ControllerType_JoyConLeftVertical:
        case ControllerType_JoyConLeftHorizontal:
        case ControllerType_HandheldLeft:
            pMessage = "Joy-Con (L) No Battery";
            break;
        case ControllerType_JoyDualRight:
        case ControllerType_JoyConRightVertical:
        case ControllerType_JoyConRightHorizontal:
        case ControllerType_HandheldRight:
            pMessage = "Joy-Con (R) No Battery";
            break;
        case ControllerType_JoyDualBoth:
        case ControllerType_HandheldBoth:
            pMessage = "Joy-Con (L)&(R) No Battery";
            break;
        case ControllerType_FullKeyController:
            pMessage = "FullKeyController No Battery";
            break;
        default:
            pMessage = "Controller No Battery";
            break;
        }
        m_pPanel->SetText(pMessage);

        m_TimeToLive = config::NotificationTtl::GetTtlControllerNoBattery();
        m_Category   = NotificationCategory_Condition;
        m_Priority   = config::ConditionPriority_ControllerNoBattery;
        return true;
    }

}}
