﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "INotification.h"

namespace scene{ namespace overlay{

    class NotificationBase
        : public INotification
    {
    public:
        NotificationBase() NN_NOEXCEPT
            : m_TimeToLive()
            , m_Category(NotificationCategory_Condition)
            , m_Priority(0)
        {
        }

        virtual nn::os::Tick GetTickToLive() const NN_NOEXCEPT NN_OVERRIDE
        {
            return nn::os::Tick(m_TimeToLive);
        }

        virtual NotificationCategory GetCategory() const NN_NOEXCEPT NN_OVERRIDE
        {
            return m_Category;
        }

        virtual NotificationPriorityType GetPriority() const NN_NOEXCEPT NN_OVERRIDE
        {
            return m_Priority;
        }

    protected:
        nn::TimeSpan             m_TimeToLive;
        NotificationCategory     m_Category;
        NotificationPriorityType m_Priority;
    };

}}
