﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>
#include <nn/nn_Common.h>
#include <nn/os.h>

#include "../../panel/panel_IPanel.h"
#include "NotificationCategory.h"

namespace scene{ namespace overlay{

    typedef int64_t NotificationPriorityType;

    class INotification
    {
    public:
        virtual ~INotification() NN_NOEXCEPT
        {
        }

        virtual nn::os::Tick GetTickToLive() const NN_NOEXCEPT =0;
        virtual std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT =0;
        virtual NotificationCategory GetCategory() const NN_NOEXCEPT =0;
        // 通知を表示する優先度を返す。
        // 優先度は値が小さい方が高優先度。
        virtual NotificationPriorityType GetPriority() const NN_NOEXCEPT =0;
        // 描画用に準備します。
        virtual void ReadyToAppear() NN_NOEXCEPT =0;
    };

}}
