﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "SceneMenuPageBase.h"
#include "../../config/QuickMenuStyle.h"

namespace scene{ namespace menu{

    class SceneQuickMenuPage
        : public SceneMenuPageBase
    {
    public:
        typedef config::QuickMenuStyle Style;

    public:
        explicit SceneQuickMenuPage(const std::shared_ptr<void>& arg) NN_NOEXCEPT;

        virtual void OnEnteringPage(const std::shared_ptr<ui::IMenuPage>&) NN_NOEXCEPT NN_OVERRIDE;
        virtual void OnClosingPage(const std::shared_ptr<ui::IMenuPage>&) NN_NOEXCEPT NN_OVERRIDE;

    private:

        std::shared_ptr<ui::IMenuItem> CreateMenuColumnImpl() NN_NOEXCEPT;
        std::shared_ptr<ui::IMenuItem> CreateMenuColumnHeaderImpl() NN_NOEXCEPT;
        std::shared_ptr<ui::IMenuItem> CreateMenuColumnFooterImpl() NN_NOEXCEPT;
        std::shared_ptr<ui::IMenuItem> CreateMenuColumnBodyImpl() NN_NOEXCEPT;

        std::shared_ptr<ui::IMenuItem> CreateLogManipulatorImpl() NN_NOEXCEPT;

    private:
        class LogManipulator
        {
        public:
            void Start(const nn::util::Vector3f& position) NN_NOEXCEPT;
            void End() NN_NOEXCEPT;
            void Move(const nn::util::Vector3f& newPosition) NN_NOEXCEPT;

        private:
            bool m_IsActive = false;
            nn::util::Vector3f m_PrevPosition = {};
        } m_LogManipulator;

    };

}}
