﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "SceneMenuPageBase.h"
#include "../../config/DebugMenuStyle.h"
#include "../debug/debug_LayoutEditorController.h"

namespace scene{ namespace menu{

    // debug::LayoutEditorController を UserArgument として渡す。
    class SceneDebugMenuLayoutEditorPage
        : public SceneMenuPageBase
    {
        typedef config::DebugMenuStyle StyleType;
    public:
        explicit SceneDebugMenuLayoutEditorPage(const std::shared_ptr<void>& arg) NN_NOEXCEPT;

        bool IsTransparent() const NN_NOEXCEPT NN_OVERRIDE { return true; }

    private:
        static std::shared_ptr<ui::IMenuItem> MakePage(const std::shared_ptr<debug::LayoutEditorController>& pController) NN_NOEXCEPT;
        static std::shared_ptr<ui::IMenuItem> MakeLayoutControlTable(const std::shared_ptr<debug::LayoutEditorController>& pController) NN_NOEXCEPT;

    };

}}
