﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "MenuPageReactor.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../../AppletMessageThread.h"
#include "SceneStackedItemMenuPage.h"

namespace scene{ namespace menu{

    MenuPageReactor::MenuPageReactor() NN_NOEXCEPT
    {
    }

    void MenuPageReactor::CloseMenu() NN_NOEXCEPT
    {
        m_IsCloseMenuRequested = true;
    }

    void MenuPageReactor::ClosePage() NN_NOEXCEPT
    {
        m_IsClosePageRequested = true;
    }

    void MenuPageReactor::OpenPage(uint32_t sceneIndex) NN_NOEXCEPT
    {
        m_PageOpenRequest = std::make_pair(sceneIndex, std::shared_ptr<void>());
    }

    void MenuPageReactor::OpenPage(uint32_t sceneIndex, const std::shared_ptr<void>& pUserArgument) NN_NOEXCEPT
    {
        m_PageOpenRequest = std::make_pair(sceneIndex, pUserArgument);
    }

    void MenuPageReactor::ChangeFocus(const std::shared_ptr<ui::IMenuItem>& newItem) NN_NOEXCEPT
    {
        m_FocusChangeRequest = newItem;
    }

    void MenuPageReactor::SleepSystem() NN_NOEXCEPT
    {
        m_AppletResponseRequest = AppletMessageMenuResponse(AppletMessageResponseMenuResultCode_Sleep);
    }

    void MenuPageReactor::ShutdownSystem() NN_NOEXCEPT
    {
        m_AppletResponseRequest = AppletMessageMenuResponse(AppletMessageResponseMenuResultCode_Shutdown);
    }

    void MenuPageReactor::SendMessage(const AppletMessageMenuResponse& message) NN_NOEXCEPT
    {
        m_AppletResponseRequest = message;
    }

    void MenuPageReactor::LoadValue() NN_NOEXCEPT
    {
        m_IsLoadValueRequested = true;
    }

    void MenuPageReactor::StoreValue() NN_NOEXCEPT
    {
        m_IsStoreValueRequested = true;
    }

    void MenuPageReactor::UpdateLayout() NN_NOEXCEPT
    {
        m_IsUpdateLayoutRequested = true;
    }

    void MenuPageReactor::UpdatePanel() NN_NOEXCEPT
    {
        m_IsUpdatePanelRequested = true;
    }

    void MenuPageReactor::SetEnablity(const std::shared_ptr<ui::IMenuItem>& pItem, bool isEnabled) NN_NOEXCEPT
    {
        m_EnablityChangeRequestList.push_back(std::make_pair(pItem, isEnabled));
    }

    void MenuPageReactor::PushMenuLayerImpl(const std::shared_ptr<ui::IMenuItem>& pItem, const ui::Position& anchor) NN_NOEXCEPT
    {
        m_LayerPushRequest = std::make_pair(
            static_cast<uint32_t>(SceneIndex_StackedItemMenuPage),
            std::static_pointer_cast<void>(std::make_shared<SceneStackedItemMenuPageArgument>(pItem, anchor))
        );
    }

    void MenuPageReactor::PopMenuLayerImpl() NN_NOEXCEPT
    {
        // ページを閉じる
        ClosePage();
    }

    bool MenuPageReactor::IsClosePageRequested() const NN_NOEXCEPT
    {
        return m_IsClosePageRequested;
    }

    bool MenuPageReactor::IsCloseMenuRequested() const NN_NOEXCEPT
    {
        return m_IsCloseMenuRequested;
    }

    bool MenuPageReactor::IsLoadValueRequested() const NN_NOEXCEPT
    {
        return m_IsLoadValueRequested;
    }

    bool MenuPageReactor::IsStoreValueRequested() const NN_NOEXCEPT
    {
        return m_IsStoreValueRequested;
    }

    bool MenuPageReactor::IsUpdateLayoutRequested() const NN_NOEXCEPT
    {
        return m_IsUpdateLayoutRequested;
    }

    bool MenuPageReactor::IsUpdatePanelRequested() const NN_NOEXCEPT
    {
        return m_IsUpdatePanelRequested;
    }

    nn::util::optional<std::pair<ui::IMenuPage::PageIndexType, std::shared_ptr<void>>> MenuPageReactor::GetPageOpenRequest() const NN_NOEXCEPT
    {
        return m_PageOpenRequest;
    }

    nn::util::optional<std::pair<ui::IMenuPage::PageIndexType, std::shared_ptr<void>>> MenuPageReactor::GetLayerPushRequest() const NN_NOEXCEPT
    {
        return m_LayerPushRequest;
    }

    nn::util::optional<std::shared_ptr<ui::IMenuItem>> MenuPageReactor::GetFocusChangeRequest() const NN_NOEXCEPT
    {
        return m_FocusChangeRequest;
    }

    nn::util::optional<AppletMessageMenuResponse> MenuPageReactor::GetAppletResponseRequest() const NN_NOEXCEPT
    {
        return m_AppletResponseRequest;
    }

    int MenuPageReactor::GetEnablityChangeRequestCount() const NN_NOEXCEPT
    {
        return static_cast<int>(m_EnablityChangeRequestList.size());
    }

    std::pair<std::shared_ptr<ui::IMenuItem>, bool> MenuPageReactor::GetEnablityChangeRequestEntry(int index) const NN_NOEXCEPT
    {
        if(index < 0 || static_cast<size_t>(index) >= m_EnablityChangeRequestList.size())
        {
            return {};
        }

        return m_EnablityChangeRequestList[index];
    }

}}

