﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include "../../panel/panel_IPanel.h"
#include "../../panel/panel_PanelContainer.h"

// モジュールを増やした場合ここでインクルードする。
#include "debug_Activity.h"
#include "debug_Clock.h"
#include "debug_PowerConsumptionMeter.h"
#include "debug_LogStorageLm.h"
#include "debug_LogViewer.h"
#include "debug_HidInputViewer.h"
#include "debug_SystemSharedTextureViewer.h"

namespace scene{ namespace debug{

#define NN_DEVOVL_DEBUGMODULE_DECL(name, data)  class name;
    NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_DECL, _);
#undef NN_DEVOVL_DEBUGMODULE_DECL

    class SceneDebug
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        void Update() NN_NOEXCEPT;
        std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT;

    public:
        bool IsActive() const NN_NOEXCEPT;
        Activity GetCurrentActivity() const NN_NOEXCEPT;

        void SubmitActivity(const Activity& value) NN_NOEXCEPT;

    #define NN_DEVOVL_DEBUGMODULE_GETMODULE(name, data) std::shared_ptr<name> Get##name() NN_NOEXCEPT { return m_p##name; }
        NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_GETMODULE, _);
    #undef NN_DEVOVL_DEBUGMODULE_GETMODULE

    private:
        void UpdateActivityImpl() NN_NOEXCEPT;

    private:
        Activity m_CurrentActivity;
        Activity m_NextActivity;
        std::shared_ptr<panel::PanelContainer> m_pRootPanel;

        // モジュール
    #define NN_DEVOVL_DEBUGMODULE_MEMPTR(name, data) std::shared_ptr<name> m_p##name;
        NN_DEVOVL_FOREACH_DEBUGMODULE(NN_DEVOVL_DEBUGMODULE_MEMPTR, _);
    #undef NN_DEBOVL_DEBUGMODULE_MEMPTR
    };

    extern SceneDebug g_SceneDebug;
    extern bool g_IsSavingActivityEnabled;

}}
