﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>
#include <emc_log_cmn.h>
#include <hos/nvgpu.h>

#include "debug_ActivityPowerConsumptionMeter.h"
#include "debug_HistoricalGraph.h"

namespace scene{ namespace debug{

    const int McbmEntryCount = 2;

    struct mcbwInfo {
        bool initialize;
        uint32_t kbps[McbmEntryCount];
    };

    class PowerConsumptionMeter
    {
    public:
        enum SeriesIndex
        {
            SeriesIndex_Gpu = 0,
            SeriesIndex_Cpu,
            SeriesIndex_Ddr,
            SeriesIndex_Max,
        };

    public:
        explicit PowerConsumptionMeter() NN_NOEXCEPT;
        ~PowerConsumptionMeter() NN_NOEXCEPT;

        void SetPosition(int x, int y) NN_NOEXCEPT;
        void SetSize(int w, int h) NN_NOEXCEPT;

        void Update() NN_NOEXCEPT;
        std::shared_ptr<panel::IPanel> GetPanel() NN_NOEXCEPT;

        void SetActivity(const ActivityPowerConsumptionMeter& value) NN_NOEXCEPT
        {
            SetPosition(value.common.positionX, value.common.positionY);
            SetSize(value.width, value.height);
        }

    private:
        // フレーム数
        int m_FrameIndex;

        // GPU やら消費電力取得用のメンバ
        int m_GpuCtrlFd;
        float m_ProductPower, m_BatteryLife, m_AvgGpuLoad;

        // メモリ帯域取得用のメンバ
        mc_stats m_McStats;
        scene::debug::mcbwInfo m_McbwInfo;

        HistoricalGraphHolder<SeriesIndex_Max> m_Graph;
        std::shared_ptr<panel::PanelContainer> m_pContainer;
        std::shared_ptr<panel::PanelText> m_pPanelText;
    };

}}
