﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace panel{

    enum Icon
    {
        Icon_None = 0,

        // - Switch 本体
        // - Handheld
        Icon_SwitchDevice,

        // - Switch Pro Controller
        // - FullKey
        Icon_SwitchProController,

        // Joy-Con 二本持ち
        Icon_JoyConDual,

        // 左 Joy-Con 縦持ち
        Icon_JoyConLeftVertical,

        // 左 Joy-Con 横持ち
        Icon_JoyConLeftHorizontal,

        // 右 Joy-Con 縦持ち
        Icon_JoyConRightVertical,

        // 右 Joy-Con 縦持ち
        Icon_JoyConRightHorizontal,
    };


    class IconToString
    {
    public:
        static const char* GetUtf8(Icon icon) NN_NOEXCEPT
        {
            switch(icon)
            {
            case Icon_SwitchDevice:          return "\uE121";
            case Icon_SwitchProController:   return "\uE12C";
            case Icon_JoyConDual:            return "\uE122";
            case Icon_JoyConLeftVertical:    return "\uE125";
            case Icon_JoyConLeftHorizontal:  return "\uE128";
            case Icon_JoyConRightVertical:   return "\uE126";
            case Icon_JoyConRightHorizontal: return "\uE129";
            default:
                return "";
            }

        }

    };
}
