﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "panel_Drawer.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "../../framework/Framework.h"

#define DEVOVL_PANEL_COMMON_SHADER_PATH "rom:/PanelShader.bnsh"

namespace panel{ namespace detail{

    void Drawer::Initilaize() NN_NOEXCEPT
    {
        m_CommonPanelShader.Initialize(DEVOVL_PANEL_COMMON_SHADER_PATH);
        // RasterizerState （共通）
        {
            nn::gfx::RasterizerStateInfo info;
            info.SetDefault();
            info.SetCullMode(nn::gfx::CullMode_None);
            info.SetPrimitiveTopologyType(nn::gfx::PrimitiveTopologyType_Triangle);
            info.SetScissorEnabled(true);
            info.SetDepthClipEnabled(false);
            m_CommonRasterizerState.Initialize(Framework::GetDevice(), info);
        }
        // DepthStencilState （共通）
        {
            nn::gfx::DepthStencilStateInfo info;
            info.SetDefault();
            info.SetDepthTestEnabled(false);
            info.SetDepthWriteEnabled(false);
            m_CommonDepthStencilState.Initialize(Framework::GetDevice(), info);
        }
        // BlendState （合成しない）
        {
            nn::gfx::BlendStateInfo info;
            info.SetDefault();
            nn::gfx::BlendTargetStateInfo targetInfo;
            targetInfo.SetDefault();
            info.SetBlendTargetStateInfoArray(&targetInfo, 1);
            m_SolidBlendState.Initialize(Framework::GetDevice(), info);
        }
        // BlendState （アルファ合成する）
        {
            nn::gfx::BlendStateInfo info;
            info.SetDefault();
            nn::gfx::BlendTargetStateInfo targetInfo;
            targetInfo.SetDefault();
            targetInfo.SetBlendEnabled(true);
            targetInfo.SetColorBlendFunction(nn::gfx::BlendFunction_Add);
            targetInfo.SetSourceColorBlendFactor(nn::gfx::BlendFactor_SourceAlpha);
            targetInfo.SetDestinationColorBlendFactor(nn::gfx::BlendFactor_OneMinusSourceAlpha);
            targetInfo.SetAlphaBlendFunction(nn::gfx::BlendFunction_Add);
            targetInfo.SetSourceAlphaBlendFactor(nn::gfx::BlendFactor_One);
            targetInfo.SetDestinationAlphaBlendFactor(nn::gfx::BlendFactor_OneMinusSourceAlpha);
            info.SetBlendTargetStateInfoArray(&targetInfo, 1);
            m_AlphaBlendState.Initialize(Framework::GetDevice(), info);
        }

        m_NextObjectId = 1;
    }

    void Drawer::Finalize() NN_NOEXCEPT
    {
        m_AlphaBlendState.Finalize(Framework::GetDevice());
        m_SolidBlendState.Finalize(Framework::GetDevice());
        m_CommonDepthStencilState.Finalize(Framework::GetDevice());
        m_CommonRasterizerState.Finalize(Framework::GetDevice());
        m_CommonPanelShader.Finalize();
    }

    int Drawer::AcquireObjectIdForDebug() NN_NOEXCEPT
    {
        return m_NextObjectId++;
    }

}}
