﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>

static const int ScreenWidth  = 1280;
static const int ScreenHeight = 720;

// 通知の大きさ(px)
static const int NotificationWidth  = 400;
static const int NotificationHeight = 108;

static const size_t OverlayDisplayThreadStackSize      = 64 * 1024;
static const size_t AppletMessageThreadStackSize       = 16 * 1024;
static const size_t OverlayNotificationThreadStackSize = 16 * 1024;

static const int AppletMessageQueueLength = 10;
static const int OverlayNotificationQueueLength = 10;

// Panel のダンプを出力するか
//#define NN_DEVOVL_ENABLE_PANEL_DUMP

// Panel の描画数を出力するか
//#define NN_DEVOVL_ENABLE_PRINT_PANELCOUNT

// SandboxPage を有効にするか
#ifdef NN_DEVOVL_IS_SYSTEM
#define NN_DEVOVL_ENABLE_SANDBOX_PAGE
#endif

// ログ
#define NN_DEVOVL_LOG(...) NN_SDK_LOG("[devovl]" __VA_ARGS__)
#define NN_DEVOVL_LOG_ERR(...) NN_SDK_LOG("[devovl][err]" __VA_ARGS__)

// フレームワークのログ
#define NN_DEVOVL_FW_LOG(...) //NN_DEVOVL_LOG("[fw]" __VA_ARGS__)

// 描画スレッドのログ
#define NN_DEVOVL_DISP_LOG(...)      //NN_DEVOVL_LOG("[disp]" __VA_ARGS__)
#define NN_DEVOVL_DISP_LOG_AMSG(...) //NN_DEVOVL_DISP_LOG("[amsg]" __VA_ARGS__)
#define NN_DEVOVL_DISP_LOG_NMSG(...) //NN_DEVOVL_DISP_LOG("[nmsg]" __VA_ARGS__)

// アプレットメッセージ受信スレッドのログ
#define NN_DEVOVL_APPM_LOG(...) //NN_DEVOVL_LOG("[appm]" __VA_ARGS__)

// オーバーレイ通知受信スレッドのログ
#define NN_DEVOVL_OVLN_LOG(...) //NN_DEVOVL_LOG("[ovln]" __VA_ARGS__)

// panel のログ
#define NN_DEVOVL_PANEL_LOG_ROOT(...)   //NN_DEVOVL_LOG("[panel]" __VA_ARGS__)
#define NN_DEVOVL_PANEL_LOG_PANEL(...)  //NN_DEVOVL_LOG("[panel]" __VA_ARGS__)
#define NN_DEVOVL_PANEL_LOG_DRAW(...)   //NN_DEVOVL_PANEL_LOG_ROOT("[draw]" __VA_ARGS__)
#define NN_DEVOVL_PANEL_LOG_RENDER(...) //NN_DEVOVL_PANEL_LOG_ROOT("[render]" __VA_ARGS__)
#define NN_DEVOVL_PANEL_LOG_DUMP(...)   //NN_DEVOVL_PANEL_LOG_ROOT("[dump]" __VA_ARGS__)

// ui のログ
#define NN_DEVOVL_UI_LOG_ROOT(...)  //NN_DEVOVL_LOG("[ui]" __VA_ARGS__)
#define NN_DEVOVL_UI_LOG_TOUCH(...) //NN_DEVOVL_UI_LOG_ROOT(__VA_ARGS__)

// menu のログ
#define NN_DEVOVL_MENU_LOG_ROOT(...) NN_DEVOVL_LOG("[menu]" __VA_ARGS__)
#define NN_DEVOVL_MENU_LOG_INFO(...) NN_DEVOVL_MENU_LOG_ROOT(__VA_ARGS__)

// debug のログ
#define NN_DEVOVL_DEBUG_LOG_ROOT(...)   NN_DEVOVL_LOG("[debug]" __VA_ARGS__)
#define NN_DEVOVL_DEBUG_LOG_INFO(...)   NN_DEVOVL_DEBUG_LOG_ROOT(__VA_ARGS__)
#define NN_DEVOVL_DEBUG_LOG_DEV_LAYOUTEDITOR(...) //NN_DEVOVL_DEBUG_LOG_ROOT("[lyt]" __VA_ARGS__)
