﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "DevMenu_SaveData.h"
#include "DevMenu_SaveDataProperty.h"

namespace devmenu { namespace savedata {

        class AbstractOperators
        {
        public:
            virtual void UpdateSaveDataDetails( const SaveDataPropertyType* const pSaveDataProperty ) const NN_NOEXCEPT = 0;
            virtual void ShowSaveDataDetails( SceneType currentListScene ) const NN_NOEXCEPT = 0;
            virtual void CloseSaveDataDetails( SceneType previousScene ) const NN_NOEXCEPT = 0;
            virtual void UpdateSaveDataTypeList( const nn::ncm::ApplicationId& applicationId ) const NN_NOEXCEPT = 0;
            virtual void ShowSaveDataTypeListScene( SceneType currentListScene ) const NN_NOEXCEPT = 0;
            virtual void CloseSaveDataTypeListScene( SceneType previousScene ) const NN_NOEXCEPT = 0;
            virtual void DeleteSaveData( SceneType currentListScene ) const NN_NOEXCEPT = 0;
            virtual void ExportSaveData( SceneType currentListScene ) const NN_NOEXCEPT = 0;
            virtual void VerifySaveData( SceneType currentListScene ) const NN_NOEXCEPT = 0;
            virtual void CorruptSaveData( SceneType currentListScene ) const NN_NOEXCEPT = 0;
            virtual void ExportRawSaveData( SceneType currentListScene ) const NN_NOEXCEPT = 0;
        };

}} // ~namespace devmenu::savedata, ~namespace devmenu

