﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_Directory.h>
#include <nn/fs/fs_FileSystem.h>

#include "../DevMenu_Common.h"
#include "../DevMenu_RootSurface.h"

namespace devmenu { namespace savedata {

/**
 * @brief srcPath で指定した ".nsave" 形式のファイルのセーブデータを destPath にコピーします。
 */
const nn::Result CopySaveDataDirectoryForNsave( const std::string& destPath, const std::string& srcPath,
    bool isJournalingEnabled = false, int64_t journalSize = 0 ) NN_NOEXCEPT;

/**
 * @brief srcPath で指定したディレクトリ以下のセーブデータを アーカイブ化してdestFile にコピーします。
 */
const nn::Result CreatePartitionFsArchive( const std::string& destFile, const std::string& destPath,
    const std::string& srcPath, char* pBackupXmlBuffer, int backupXmlBufferSize, char* pConfigXmlBuffer, int configXmlBufferSize ) NN_NOEXCEPT;

// DevMenu では使用しなくなったが CustomerSupportTool では使用する
const nn::Result GetFsEntries( nn::fs::DirectoryHandle* pOutDirectoryHandle, nn::fs::DirectoryEntry** ppDirectoryEntryArea, int64_t* pOutReadCount,
    const std::string& directoryPath, nn::fs::OpenDirectoryMode mode ) NN_NOEXCEPT;

}} // ~namespace devmenu::savedata, ~namespace devmenu

