﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "DevMenu_SaveDataConfig.h"

namespace devmenu { namespace savedata {

    // DataMoveInfo
    const std::string DataMoveInfo::ExportPathRoot = "sd:/NintendoSDK/BackupSaveData";
    const std::string DataMoveInfo::ConfigFileName = "config.xml";

    const DataMoveInfo::SaveDataTypeDirectoryInfo DataMoveInfo::TypeDirectoryInfo[ 6 ] = {
        { nn::fs::SaveDataType::System   , "/system/" },
        { nn::fs::SaveDataType::Account  , "/user/" },
        { nn::fs::SaveDataType::Bcat     , "/bcat/" },
        { nn::fs::SaveDataType::Device   , "/device/" },
        { nn::fs::SaveDataType::Temporary, "/temp/" }, // 処理の対象外なので使用されることはない
        { nn::fs::SaveDataType::Cache    , "/cache/" },
    };

    const std::string DataMoveInfo::ExportedSaveDataInfoFileName = "__BackupSaveDataInfo.xml";

#if defined ( NN_CUSTOMERSUPPORTTOOL )
    const std::string DataMoveInfo::NsaveFilenameExtension = ".nsave";
    const int DataMoveInfo::ConfigXmlRootPathStringSize = 32;
    const int DataMoveInfo::XmlFileCount = 2;
    const int64_t DataMoveInfo::NsaveFileMaxSize = 0x80000000LL;

    const size_t DataMoveInfo::SaveDataDateStrLength = 14;
    const size_t DataMoveInfo::SaveDataApplicationIdStrLength = 16;
    const size_t DataMoveInfo::UserStrLength = 4;
    const size_t DataMoveInfo::NumberingStrLength = 4;
    const size_t DataMoveInfo::DirectoryStrLength = SaveDataDateStrLength + 1 + SaveDataApplicationIdStrLength + 1 + UserStrLength + 1 + SaveDataApplicationIdStrLength + 1 + NumberingStrLength + 1;

    const int DataMoveInfo::DirectorySearchPosition = 4;
    const int DataMoveInfo::RelativePathPosition = 3;
    const int DataMoveInfo::MountDelimiterStrLength = 2;
#endif

    // Default
    const float Default::FontSize                 = 22.0f;
    const float Default::FontSizeMedium           = 19.0f;
    const float Default::FontSizeSmall            = 16.0f;
    const int   Default::MaxApplicationNameLength = 128;

    const float Default::ButtonHeight             = 40.0f;
    const float Default::ButtonWidthBack          = 164.0f;
    const float Default::ButtonWidthExport        = 256.0f;
    const float Default::ButtonWidthVerify        = 256.0f;
    const float Default::ButtonWidthDelete        = 256.0f;
    const float Default::ButtonWidthCorrupt       = 256.0f;
    const float Default::ButtonWidthExportRaw     = 256.0f;
    const float Default::PlacerOffsetHorizontal   = 24.0f;
    const float Default::PlacerOffsetVertical     = 4.0f;

    const glv::space_t Default::HeaderRegion       = 48.0f;
    const glv::space_t Default::FooterRegion       = 80.0f;
    const glv::space_t Default::ListMarginLeft     = 16.0f;
    const glv::space_t Default::ListMarginRight    = 16.0f;

    const char* Default::ApplicationIdStatementFormat = "0x%016llX";
    const char* Default::SaveDataIdStatementFormat = "0x%016llX";

}} // ~namespace devmenu::savedata, ~namespace devmenu
