﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>

#include "DevMenu_DeviceSettingsCommon.h"
#include "../Common/DevMenu_CommonScene.h"
#include "../Common/DevMenu_CommonScrollBox.h"
#include "../DevMenu_RootSurface.h"

namespace devmenu { namespace devicesettings {

class ItemListScene : public Scene
{
public:
    ItemListScene( Page* pPage, const glv::Rect& rect ) NN_NOEXCEPT;

    /**
     * @brief    Added Subsections to ItemListScene and set the focus transition path.
     *
     * @pre      RootSurfaceContext pointer of the parent page (m_RootContext) is not nullptr.
     */
    void PrepareSubsections() NN_NOEXCEPT;

    void OnChangeIntoForeground() NN_NOEXCEPT;

    virtual void OnActivatePage() NN_NOEXCEPT NN_OVERRIDE;

    virtual void OnLoopBeforeSceneRenderer( glv::ApplicationLoopContext& context, const glv::HidEvents& events ) NN_NOEXCEPT NN_OVERRIDE;

    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

private:
    FocusManager           m_FocusManager;
    ScrollableBoxView      m_ScrollableContainer;
    std::vector< SubsectionWithFocusUtility* > m_SubsectionList;
};

}} // ~namespace devmenu::devicesettings, ~namespace devmenu
