﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <vector>

#include <nn/settings/system/settings_Tv.h>

#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    #include <nn/vi/vi_DisplayMode.private.h>
#endif

#include "../Common/DevMenu_CommonDropDown.h"
#include "../Common/DevMenu_CommonIconButton.h"
#include "../Common/DevMenu_CommonIconLabel.h"
#include "DevMenu_DeviceSettingsCommon.h"

namespace devmenu { namespace devicesettings {

/**************************************
 * class BrightnessSetting
 **************************************/
class BrightnessSetting : public glv::Table
{
public:
    explicit BrightnessSetting( glv::space_t width ) NN_NOEXCEPT;

    void Update() NN_NOEXCEPT;

    void UpdateAutoBrightness( bool checked ) NN_NOEXCEPT;

    void UpdateAutoBrightness( const glv::Notification& notification ) NN_NOEXCEPT;

    void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView ) NN_NOEXCEPT;

    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;

    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    glv::Slider*    m_pSlider;
    CheckBoxButton* m_pCheckbox;
};

/**************************************
 * class DisplayResolutionDropDown
 **************************************/
class DisplayResolutionDropDown : public devmenu::DropDownBase
{
public:
    DisplayResolutionDropDown( const glv::Rect& rect, float textSize ) NN_NOEXCEPT;

    void UpdateDisplayResolution() NN_NOEXCEPT;

    // Checks for a change in the HDMI state and updates the drop down list
    void UpdateDisplayModes() NN_NOEXCEPT;

private:
    // Sets up the drop down list for the external display
    void InitializeExternalDropDownList() NN_NOEXCEPT;

    // Sets up the drop down list for the native device display
    void InitializeDefaultDropDownList() NN_NOEXCEPT;

    static const char* GetResolutionLabelString( nn::settings::system::TvResolution resolution ) NN_NOEXCEPT;

#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    static nn::settings::system::TvResolution GetTvResolutionFromDisplayMode( const nn::vi::DisplayModeInfo& mode ) NN_NOEXCEPT;
#endif

private:

#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    nn::vi::Display* m_pExternalDisplay;
    std::vector< std::pair< nn::settings::system::TvResolution, nn::vi::DisplayModeInfo > > m_ExternalModes;
#endif

    bool m_IsDisplayConnected;
};

/**************************************
 * class DisplaySetting
 **************************************/
class DisplaySetting : public glv::Table
{
public:
    explicit DisplaySetting( glv::space_t width ) NN_NOEXCEPT;

    void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* previous, glv::View* next ) NN_NOEXCEPT;

    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;

    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

    void UpdateDropDownList() NN_NOEXCEPT;

private:
    DisplayResolutionDropDown* m_pDropDown;
};

/**************************************
 * class CecEnabledSetting
 **************************************/
class CecEnabledSetting : public glv::Table
{
private:

    class CecEnabledDropDown : public DropDownBase
    {
    public:
        CecEnabledDropDown( const glv::Rect& rect, float textSize ) NN_NOEXCEPT;

        void Refresh() NN_NOEXCEPT;

    private:

        static bool GetSettingsValue() NN_NOEXCEPT;

        static void SetSettingsValue( bool value ) NN_NOEXCEPT;

        void UpdateSettingsValue() NN_NOEXCEPT;
    };

public:
    explicit CecEnabledSetting( glv::space_t width ) NN_NOEXCEPT;

    void Refresh() NN_NOEXCEPT;

    void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView ) NN_NOEXCEPT;

    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;

    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

private:
    CecEnabledDropDown* m_pDropDown;
};

/**************************************
 * class UnderscanSetting
 **************************************/
class UnderscanSetting : public glv::Table
{
public:
    explicit UnderscanSetting( glv::space_t width ) NN_NOEXCEPT;

    void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousView, glv::View* pNextView ) NN_NOEXCEPT;

    glv::View* GetFirstFocusTargetView() NN_NOEXCEPT;

    glv::View* GetLastFocusTargetView() NN_NOEXCEPT;

    void UpdateUnderscan( int underscanDelta ) NN_NOEXCEPT;

private:
    static constexpr int UnderscanValueMax = 20;
    static constexpr int UnderscanValueMin = 0;

private:
    void RegisterUpdateUnderscanFunction() NN_NOEXCEPT;

private:
    glv::Label* m_pUnderscanLabel;
    glv::View* m_pUnderscanUp;
    glv::View* m_pUnderscanDown;
#if defined( NN_BUILD_CONFIG_OS_HORIZON )
    nn::vi::Display* m_pExternalDisplay;
#endif
};

/**************************************
 * class DisplaySettings
 **************************************/
class DisplaySettings : public SubsectionWithFocusUtility
{
public:
    DisplaySettings( Page* pPage, glv::space_t width ) NN_NOEXCEPT;

    virtual void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousFocusItem, glv::View* pNextFocusItem ) const NN_NOEXCEPT final NN_OVERRIDE;
    virtual glv::View* GetFirstFocusTargetView() const NN_NOEXCEPT final NN_OVERRIDE;
    virtual glv::View* GetLastFocusTargetView() const NN_NOEXCEPT final NN_OVERRIDE;

    virtual void OnLoopBeforeSceneRenderer() NN_NOEXCEPT final NN_OVERRIDE;
    virtual void OnLoopAfterSceneRenderer() NN_NOEXCEPT final NN_OVERRIDE;
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;

private:
    BrightnessSetting*    m_pBrightness;
    DisplaySetting*       m_pDisplay;
    CecEnabledSetting*    m_pCec;
    UnderscanSetting*     m_pUnderscan;
};

}} // ~namespace devmenu::devicesettings, ~namespace devmenu
