﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <vector>
#include "../Common/DevMenu_CommonDropDown.h"
#include "../Common/DevMenu_CommonScrollBox.h"
#include "../Common/DevMenu_CommonFocusManager.h"
#include "../DevMenu_Common.h"
#include "../DevMenu_Config.h"
#include "../DevMenu_RootSurface.h"

namespace devmenu { namespace devicesettings {

static const glv::Label::Spec DefaultLabelSpec( glv::Place::TL, 5.0f, 0.0f, CommonValue::InitialFontSize );
static const glv::Rect DefaultDropDownRect( glv::Rect( 160.0f, 35.0f ) );

template < typename T >
std::string ToString( T data, std::streamsize width ) NN_NOEXCEPT
{
        std::ostringstream out;
        out << std::setw( width ) << std::setfill( '0' ) << static_cast<int>( data );
        return out.str();
}

struct FocusManagerUtility
{
    virtual void SetFocusTransitionPath( FocusManager* pFocusManager, glv::View* pPreviousFocusItem, glv::View* pNextFocusItem ) const NN_NOEXCEPT = 0;
};

class Subsection : public glv::Table
{
public:
    Subsection( Page* pPage, const char* headerText, glv::space_t width )  NN_NOEXCEPT;

    static glv::Table* CreateCategoryHeader( const char* text, const glv::Label::Spec& spec, const glv::Rect& rect ) NN_NOEXCEPT;

    virtual glv::View* GetFirstFocusTargetView() const NN_NOEXCEPT = 0;
    virtual glv::View* GetLastFocusTargetView() const NN_NOEXCEPT = 0;

    virtual void OnLoopBeforeSceneRenderer() NN_NOEXCEPT = 0;
    virtual void OnLoopAfterSceneRenderer() NN_NOEXCEPT = 0;
    virtual void Refresh() NN_NOEXCEPT = 0;

protected:
    inline glv::space_t GetItemWidth() NN_NOEXCEPT
    {
        return this->w - this->paddingX() * 2;
    }

private:
    static constexpr glv::space_t  RightPadding = 30.0f;
    static const glv::Label::Spec  HeaderLabelSpec;
};

class SubsectionWithFocusUtility : public Subsection, public FocusManagerUtility
{
public:
    SubsectionWithFocusUtility( Page* pPage, const char* headerText, glv::space_t width )  NN_NOEXCEPT;
};

}} // ~namespace devmenu::devicesettings, ~namespace devmenu
