﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>

namespace devmenu {

/**
 * @brief       サウンドシステムを初期化します。
 */
void InitializeSound() NN_NOEXCEPT;

/**
 * @brief       サウンドシステムを終了します。
 */
void FinalizeSound() NN_NOEXCEPT;

/**
 * @brief       サウンドシステムをサスペンドします。
 */
void SuspendSound() NN_NOEXCEPT;

/**
 * @brief       サウンドシステムをレジュームします。
 */
void ResumeSound() NN_NOEXCEPT;

/**
 * @brief       テストサウンドを再生します。
 */
void PlaybackTestSound(int channelCount) NN_NOEXCEPT;

#if !defined( NN_DEVMENULOTCHECK )

/**
 * @brief       サウンドシステムが制御すべきAEメッセージ通知の受信許可状態の制御を行います。
 *
 * @param[in]   permission  true の場合、サウンドシステムに対するメッセージ通知を許可します。
 *                          false の場合、サウンドシステムに対するメッセージ通知を拒否します。
 *
 * @return      前回の通知許可状態を返します。
 *
 * @details     通知メッセージは受信許可された状態の時のみ通知されます。
 */
bool EnableNotificationMessageReceivingOnSound( bool permission ) NN_NOEXCEPT;

#else

NN_FORCEINLINE bool EnableNotificationMessageReceivingOnSound( bool permission ) NN_NOEXCEPT
{
    NN_UNUSED( permission );
    return false;
}

#endif  // !defined( NN_DEVMENULOTCHECK )

} // end of namespace devmenu
