﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_ModalView.h"

namespace devmenu { namespace rid {

bool IsRetailInteractiveDisplay() NN_NOEXCEPT;

bool IsRetailInteractiveDisplayMenu( nn::ncm::ApplicationId applicationId ) NN_NOEXCEPT;

bool IsRetailInteractiveDisplayMenuInstalled() NN_NOEXCEPT;

bool IsRetailInteractiveDisplayMenuRunning( bool isRetailInteractiveDisplayModeRequired = true ) NN_NOEXCEPT;

void LaunchRetailInteractiveDisplayMenu( bool isAutoBoot ) NN_NOEXCEPT;

class ApplicationExitMenu
    : public MessageView
{
    NN_DISALLOW_COPY( ApplicationExitMenu );
    NN_DISALLOW_MOVE( ApplicationExitMenu );

public:
    explicit ApplicationExitMenu() NN_NOEXCEPT;
};

}} // ~namespace devmenu::rid, ~namespace devmenu::

