﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include <cstdlib>

namespace devmenu {

class PeakMemoryMeasurer
{
public:
    //!--------------------------------------------------------------------------------------
    //! @brief メジャー初期化。( nninitStartup で呼び出してください )
    //! @param[in] reservedHeapByteSize アプリケーションで予約するヒープメモリ上限サイズをバイト単位で指定します。
    //! @details 内部でヒープメモリを準備し、アロケータを初期化します。@n
    //! 通常モードでは、nn::init::InitializeAllocator を呼び出します。@n
    //! 計測モードでは、計測用のアロケータを呼び出します。
    //!--------------------------------------------------------------------------------------
    static void InitializeMeasurerOnStartup( const size_t reservedHeapByteSize ) NN_NOEXCEPT;

    //!--------------------------------------------------------------------------------------
    //! @brief メジャー初期化( nnMain で呼び出してください )
    //!--------------------------------------------------------------------------------------
    static void InitializeMeasurerOnMain() NN_NOEXCEPT;

    //!--------------------------------------------------------------------------------------
    //! @brief メジャー終了
    //!--------------------------------------------------------------------------------------
    static void FinalizeMeasurerOnMain() NN_NOEXCEPT;

};

} // ~namespace devmenu
