﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv_core.h>
#include <glv_texture.h>
#include <nn/image/image_JpegDecoder.h>

#include "Common/DevMenu_Buffer.h"

namespace devmenu {

/*********************************
 * struct Icon
 *********************************/

struct Icon
    : public glv::View
{
public:
    Icon( glv::GLsizei width, glv::GLsizei height, glv::space_t paddingX, glv::space_t paddingY ) NN_NOEXCEPT;
    virtual ~Icon() NN_NOEXCEPT;
    void SetTexture( const void* pIconBuffer, size_t iconSize ) NN_NOEXCEPT;
    void SetTexture( const devmenu::Buffer& jpegData ) NN_NOEXCEPT;
    void SetRawTexture( const unsigned char* rawImageData, uint32_t rawImageSize ) NN_NOEXCEPT;
    void ClearTexture() NN_NOEXCEPT;
    virtual void onDraw( glv::GLV& glvRoot ) NN_NOEXCEPT;
    void ActivateTexture() NN_NOEXCEPT;

protected:
    bool Decode( const devmenu::Buffer& jpegData ) NN_NOEXCEPT;

private:
    mutable nn::os::Mutex m_Lock;
    glv::Texture2* m_pTexture;
    glv::space_t m_PaddingX;
    glv::space_t m_PaddingY;
};

class ApplicationIcon
    : public Icon
{
public:
    ApplicationIcon( glv::GLsizei width, glv::GLsizei height, glv::space_t paddingX, glv::space_t paddingY ) NN_NOEXCEPT;
    virtual void SetTexture( const void* pIconBuffer, size_t iconSize ) NN_NOEXCEPT;
    static bool IsValid( const devmenu::Buffer& jpegData ) NN_NOEXCEPT;
};

} // ~namespace devmenu
