﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_RadioButtons.h"

namespace devmenu {

struct RadioButtonConfig
{
    static const float RectWidth;
    static const float RectHeight;
    static const float IndentWidth;
};

template< typename T >
class RadioButtonsConfirmView : public MessageView
{
    NN_DISALLOW_COPY( RadioButtonsConfirmView );
    NN_DISALLOW_MOVE( RadioButtonsConfirmView );

public:
    explicit RadioButtonsConfirmView( const typename RadioButtons< T >::ButtonInfoList& buttonInfoList, int defaultIndex, bool isVertical ) NN_NOEXCEPT
        : MessageView ( true )
        , m_RadioButtons(
            glv::Rect( RadioButtonConfig::RectWidth, RadioButtonConfig::RectHeight ),
            buttonInfoList, defaultIndex, isVertical,
            [&]( int index ) { OnSelected( index ); },
            RadioButtonConfig::IndentWidth )
    {
    }

    // Expected to be called in final step
    void ExtentSize() NN_NOEXCEPT
    {
        const auto maxWidth = m_ViewTable.width();
        const auto correctionWidth = ( maxWidth - width() ) / 2.0f;

        extent( maxWidth, m_ViewTable.height() );
        m_ButtonsTable.anchor( glv::Place::BC ).pos( m_ButtonsTable.left() + correctionWidth, m_ButtonsTable.top() );
    }

    T GetSelectedValue() NN_NOEXCEPT { return m_RadioButtons.GetSelectedValue(); }

    RadioButtons<T>& GetRadioButtons() NN_NOEXCEPT { return m_RadioButtons; }

protected:

    virtual void OnSelected( int itemIndex ) NN_NOEXCEPT
    {
        // 必要なら override できるようにだけしておく
    }

    void AddRadioButtons() NN_NOEXCEPT { m_ViewTable << m_RadioButtons; };

private:
    RadioButtons<T> m_RadioButtons;
};

} // end of devmenu namespace
