﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../DevMenu_ModalView.h"

namespace devmenu {

class IconLabel : public glv::Label
{
public:
    IconLabel( const glv::WideCharacterType* text, const glv::Label::Spec& spec ) NN_NOEXCEPT;
    virtual void onDraw( glv::GLV& glvRoot ) NN_NOEXCEPT NN_OVERRIDE;
    void UpdateStyle( bool isEnabled ) NN_NOEXCEPT;

    void SetValue( const glv::WideCharacterType* text ) NN_NOEXCEPT;

protected:
    const glv::WideCharacterType* m_Text;
    bool m_IsEnabled = true;
};

struct IconCodePoint
{
    static const glv::WideCharacterType* ArrowUp;
    static const glv::WideCharacterType* ArrowDown;
    static const glv::WideCharacterType* Check;
    static const glv::WideCharacterType* ControllerButtonFilledHome;
    static const glv::WideCharacterType* ControllerButtonFilledX;
    static const glv::WideCharacterType* GameCard;
    static const glv::WideCharacterType* GameCardMissing;
    static const glv::WideCharacterType* Power;
    static const glv::WideCharacterType* SaveData;
    static const glv::WideCharacterType* CircleO;
    static const glv::WideCharacterType* DotCircleO;
    static const glv::WideCharacterType* Warning;
};

} // ~namespace devmenu
