﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../DevMenu_Common.h"
#include "DevMenu_CommonIconLabel.h"

namespace devmenu {

class IconButton : public glv::Button
{
public:
    IconButton( const glv::Rect&, bool printsBorder ) NN_NOEXCEPT;
    IconButton( const glv::Rect&, bool printsBorder, IconLabel* pIconLabel ) NN_NOEXCEPT;
    IconButton( const glv::Rect&, bool printsBorder, IconLabel* pIconLabel, std::function< void() > callback, float fontSize = CommonValue::InitialFontSize) NN_NOEXCEPT;

    virtual void onDraw( glv::GLV& glvRoot ) NN_NOEXCEPT NN_OVERRIDE;
    void UpdateIcon(const glv::WideCharacterType* text  ) NN_NOEXCEPT { m_pIconLabel->SetValue(text); };
private:
    void SetDefaultButtonStyles( bool printsBorder ) NN_NOEXCEPT;

    IconLabel* m_pIconLabel;
    std::function< void() > m_Callback;
};



} // ~namespace devmenu
