﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Common/DevMenu_CommonScrollBox.h"
#include "DevMenu_CloudBackupCommons.h"

namespace devmenu { namespace cloudbackup {

ScrollFocusManager::ScrollFocusManager(ScrollableBoxView* pScrollableBoxView) NN_NOEXCEPT
    : FocusManager()
    , m_pParentScroll(pScrollableBoxView)
{
    // NOOP
}

void ScrollFocusManager::SetParentScroll(ScrollableBoxView* pScrollableBoxView) NN_NOEXCEPT
{
    m_pParentScroll = pScrollableBoxView;
}

bool ScrollFocusManager::onEvent(glv::View& view, glv::GLV& glvRoot) NN_NOEXCEPT
{
    auto list = GetFocusSwitchList();
    for (const auto& focusSwitch : list)
    {
        const auto className = std::string(view.className());

        if (focusSwitch.pPreviousView == &view)
        {
            const auto eventType = glvRoot.eventType();
            const bool needsFocusSwitch = (
                (eventType == glv::Event::BasicPadDown || eventType == glv::Event::BasicPadRepeat) && glvRoot.getBasicPadEvent().GetButtons().Test(focusSwitch.basicButtonIndex)) ||
                ((eventType == glv::Event::DebugPadDown || eventType == glv::Event::DebugPadRepeat) && glvRoot.getDebugPadEvent().GetButtons().Test(focusSwitch.debugButtonIndex));

            if (!needsFocusSwitch)
            {
                continue;
            }

            if (nullptr == focusSwitch.pNextView)
            {
                return false;
            }

            glvRoot.setFocus(focusSwitch.pNextView);
            if (m_pParentScroll != nullptr) {
                m_pParentScroll->ScrollTo(focusSwitch.pNextView);
            }
            return false;
        }
    }
    return true;
}

/**
* 引数:textで受け取ったタイトル文字列を基に、カテゴリヘッダViewを作成します。
*/
glv::Table* CreateCategoryHeader(const char* text, const glv::Label::Spec& spec, const glv::Rect& rect) NN_NOEXCEPT
{
    // Header style
    static glv::Style s_HeaderStyle;
    s_HeaderStyle.color.text.set(0.6f, 0.6f, 0.6f);
    auto pHeader = new glv::Table("<", 0.0f, 0.0f, rect);
    auto pTitle = new glv::Label(text, spec);
    auto pDivider = new glv::Divider(10.0f, 2.0f);

    pTitle->style(&s_HeaderStyle);
    *pHeader << pTitle << pDivider;
    pHeader->arrange();
    return pHeader;
}

}} // ~namespace devmenu::cloudbackup, ~namespace devmenu
