﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ns/ns_ApplicationViewApi.h>

namespace devmenu { namespace application {

struct Default
{
    static const float FontSize;
    static const float FontSizeSmall;
    static const int   MaxApplicationNameLength;

    static const float ButtonHeight;
    static const float ButtonWidthLaunch;
    static const float ButtonWidthBack;
    static const float ButtonWidthHashInfo;
    static const float ButtonWidthDelete;
    static const float ButtonWidthShowLegalInfo;
    static const float PlacerOffsetX;
    static const float PlacerOffsetY;
};

const nn::ncm::ApplicationId InvalidApplicationId = nn::ncm::ApplicationId::GetInvalidId();
const nn::ns::ApplicationView InvalidApplicationView = { InvalidApplicationId, 0, { { 0 } }, { 0 }, { 0 } };

}} // ~namespace devmenu::application, ~namespace devmenu
