﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/fs/fs_GameCard.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_StringUtil.h>

#include "DevMenu_ApplicationsCommon.h"

namespace devmenu { namespace application {

const char* GetApplicationIdStatementFormat() NN_NOEXCEPT
{
#if defined( NN_BUILD_CONFIG_ADDRESS_SUPPORTS_64 )
    return "0x%016llX";
#else
    return "0x%016lX";
#endif
}

void GetHashString( std::string* outDisplayStr, std::string* outQrCodeStr, void* hash, int length ) NN_NOEXCEPT
{
    char* workHash = reinterpret_cast< char* >( hash );
    *outDisplayStr = *outQrCodeStr = std::string( "" );

    for ( int i = 0; i < length; ++i )
    {
        char str[ 3 ];
        str[ 2 ] = '\0';
        nn::util::SNPrintf( str, 3, "%02x", static_cast< int >( workHash[ i ] ) );

        if ( ( nn::fs::GameCardImageHashSize / 2 ) == i )
        {
            // 表示用のハッシュ文字列にのみ改行とスペースを追加する
            *outDisplayStr += "\n  ";
        }
        *outDisplayStr += std::string( str );
        *outQrCodeStr += std::string( str );
    }
}

const nn::Result GetApplicationControlData( size_t* pOutSize, std::unique_ptr< char[] >* outBuffer, nn::ns::ApplicationControlSource source, const nn::ncm::ApplicationId& id ) NN_NOEXCEPT
{
    const size_t bufferSize = 144 * 1024; // Icon サイズ(<= 128 KiB) + 16 KiB
    std::unique_ptr< char[] > buffer( new char[ bufferSize ] );

    const auto result = nn::ns::GetApplicationControlData( pOutSize, buffer.get(), bufferSize, source, id );

    if ( result.IsSuccess() )
    {
        *outBuffer = std::move( buffer );
    }
    else
    {
        DEVMENU_LOG_DEBUG( "GetApplicationControlData failed (result: 0x%08x)\n", result.GetInnerValueForDebug() );
    }

    return result;
}

}} // ~namespace devmenu::application, ~namespace devmenu
