﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <glv/detail/glv_GfxTextApi.h>
#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForAdministrators.h>
#include <vector>

#include "../Common/DevMenu_Buffer.h"

namespace devmenu { namespace accounts {

struct NsaId
{
    bool has;
    uint64_t id;

    NsaId() NN_NOEXCEPT
        : has(false)
    {
    }
    NN_IMPLICIT NsaId(const nn::account::NetworkServiceAccountId& nsaId) NN_NOEXCEPT
        : has(true)
        , id(nsaId.id)
    {
    }
    NsaId(const NsaId& rhs) NN_NOEXCEPT
        : has(rhs.has)
        , id(rhs.id)
    {
    }
    NN_EXPLICIT_OPERATOR bool() const NN_NOEXCEPT
    {
        return has;
    }
    NN_IMPLICIT operator nn::account::NetworkServiceAccountId() const NN_NOEXCEPT
    {
        NN_ABORT_UNLESS(has);
        nn::account::NetworkServiceAccountId nsaId = { id };
        return nsaId;
    }
};

nn::account::Uid CreateUserAccount() NN_NOEXCEPT;
nn::Result DeleteUserAccount(const nn::account::Uid& user) NN_NOEXCEPT;
void SetDefaultProfile(nn::account::ProfileEditor& editor) NN_NOEXCEPT;

devmenu::Buffer LoadUserIcon(const nn::account::Uid& uid) NN_NOEXCEPT;
void GetNickname(glv::CharTypeU16* dst, int dstLength, const nn::account::Uid& uid) NN_NOEXCEPT;
bool IsNetworkServiceAccountRegistered(const nn::account::Uid& user) NN_NOEXCEPT;
NsaId GetNetworkServiceAccountId(const nn::account::Uid& user) NN_NOEXCEPT;
bool GetNintendoAccountScreenName(char* out, size_t outSize, const nn::account::Uid& user) NN_NOEXCEPT;

int UidToString(char* dst, size_t dstSize, const nn::account::Uid& uid) NN_NOEXCEPT;
int NsaIdToString(char* dst, size_t dstSize, nn::account::NetworkServiceAccountId nsaId) NN_NOEXCEPT;

struct NicknameSelection {
    enum class SelectionKind : uint8_t
    {
        String,
        Keyboard,
    } kind;

    char data[nn::account::NicknameBytesMax + 1];
};

enum class NicknameType : uint8_t
{
    Normal,
    ExtraFont,
    NoFont,
};

const char* GetKeyboradInputName() NN_NOEXCEPT;

std::vector<nn::account::Nickname> GetNicknames(NicknameType nicknameType) NN_NOEXCEPT;

}} // ~namespace devmenu::accounts, ~namespace devmenu
