﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <atomic>

#include <glv_ScissorBoxView.h>
#include <nn/nn_Common.h>
#include <nn/pdm/pdm_SystemTypes.h>

#include "DevMenu_AccountsConfig.h"
#include "DevMenu_AccountsUiComponents.h"
#include "../Common/DevMenu_CommonScene.h"

namespace devmenu { namespace accounts {

class PlayDataInfoScene
    : public Scene
{
private:

    class PlayStatisticsView
        : public glv::View
    {
    private:
        const glv::Label::Spec LabelSpec;
        glv::Placer m_Placer;
        glv::Table m_Table;
        ApplicationIcon m_Icon;
        glv::Label m_ApplicationIdLabel;
        glv::Label m_ApplicationIdValue;
        glv::Label m_PlayCountLabel;
        glv::Label m_PlayCountValue;
        glv::Label m_PlayTimeLabel;
        glv::Label m_PlayTimeValue;
    public:
        PlayStatisticsView() NN_NOEXCEPT;
        void SetPlayStatistics(const nn::pdm::PlayStatistics& statistics) NN_NOEXCEPT;
    };

    class UserInfoView
        : public glv::View
    {
    private:
        glv::Table m_Table;
        UserIcon m_Icon;
        glv::Label* m_pNickname;
        glv::Label m_Uid;
    public:
        UserInfoView() NN_NOEXCEPT;
        void SetAccount(const nn::account::Uid& uid) NN_NOEXCEPT;
    };

    static const int PlayStatisticsCount = 2;
    nn::account::Uid m_User;
    glv::ScissorBoxView m_Base;
    glv::Placer m_Placer;
    glv::Label m_Header;
    glv::Label m_NoStatisticsMessage;
    UserInfoView m_UserInfoView;
    PlayStatisticsView m_PlayStatisticsView[PlayStatisticsCount];

    class Closer : public Button
    {
    private:
        const AbstractOperators& m_Op;
        void CloseEventCallback() NN_NOEXCEPT
        {
            m_Op.ClosePlayDataInfo();
        }
    public:
        Closer(const AbstractOperators& op, const glv::Rect& r, glv::Place::t anchor = glv::Place::TC) NN_NOEXCEPT
            : Button("Back", [&] {CloseEventCallback(); }, r, anchor)
            , m_Op(op)
        {

        }
    } m_Closer;

public:
    PlayDataInfoScene(const AbstractOperators& op, glv::Rect rect) NN_NOEXCEPT;
    ~PlayDataInfoScene() NN_NOEXCEPT;

    glv::View* GetPrimaryView() NN_NOEXCEPT;

    void SetAccount(const nn::account::Uid& user) NN_NOEXCEPT;
    void Clear() NN_NOEXCEPT;
    void Refresh() NN_NOEXCEPT;
};

}} // ~namespace devmenu::accounts, ~namespace devmenu

