﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DevMenu_AccountsConfig.h"
#include "DevMenu_AccountsUiComponents.h"
#include "../Common/DevMenu_CommonCheckBox.h"
#include "../Common/DevMenu_CommonScene.h"
#include "../Common/DevMenu_CommonScrollBox.h"

#include <nn/nn_Common.h>
#include <nn/account/account_ApiForAdministrators.h>

namespace devmenu { namespace accounts {

class FwdbgScene
    : public Scene
{
private:
    class Closer
        : public Button
    {
    private:
        const AbstractOperators& m_Op;
        FwdbgScene& m_Parent;


    public:
        Closer(const AbstractOperators& op, FwdbgScene& parent, const glv::Rect& r, glv::Place::t anchor = glv::Place::TL) NN_NOEXCEPT;
    };

    // SIGLO-22661 ネットワークサービスアカウントの利用時にニンテンドーアカウントの所有の検査を省略するか
    void UpdateNaRequiredCheckbox( const glv::Notification& n ) NN_NOEXCEPT;
    // SIGLO-70255 オンラインサービスの利用資格をチェックするかどうか
    void UpdateNaLicenseVerificationEnabledCheckbox( const glv::Notification& n ) NN_NOEXCEPT;
    // ユーザー選択省略可能時に省略するか
    void UpdateSkipSelectionCheckbox( const glv::Notification& n ) NN_NOEXCEPT;
    // プログラム間で Open 状態を維持するか
    void UpdateInterprogramOpenUserRetentionCheckbox( const glv::Notification& n ) NN_NOEXCEPT;
    // BG デーモンを一時停止するか
    void UpdateSuspendBgDaemonCheckbox( const glv::Notification& n ) NN_NOEXCEPT;

    void Close() NN_NOEXCEPT;

    glv::Label m_Header;
    glv::Label m_Footer;
    ScrollableBoxView m_Container;

    devmenu::CheckBoxButton m_NaRequiredCheckbox;
    devmenu::CheckBoxButton m_NaLicenseVerificationEnabledCheckbox;
    devmenu::CheckBoxButton m_SkipSelectionCheckbox;
    devmenu::CheckBoxButton m_InterprogramOpenUserRetentionCheckbox;
    devmenu::CheckBoxButton m_SuspendBgDaemonCheckbox;

    nn::account::Declaration m_Suspension;
    nn::account::Declaration m_Retention;

    Closer m_Closer;
    Scene* m_pPreviousScene;

public:
    FwdbgScene(AbstractOperators& op, glv::Rect rect, Scene* pParent) NN_NOEXCEPT;
    ~FwdbgScene() NN_NOEXCEPT
    {
        Clear();
    }
    glv::View* GetPrimaryView() NN_NOEXCEPT
    {
        return &m_Closer;
    }
    void Clear() NN_NOEXCEPT;
    void CloseScene() NN_NOEXCEPT;
    virtual void Refresh() NN_NOEXCEPT final NN_OVERRIDE;
};

}} // ~namespace devmenu::accounts, ~namespace devmenu
