﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <sstream>
#include <iostream>
#include <iomanip>
#include <cstdlib>
#include <string>
#include <list>
#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/fs.h>
#include <nn/os.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_FormatString.h>
#include <nn/nifm.h>
#include <nn/ns/ns_Result.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/ns/ns_DevelopApi.h>
#include <nn/ns/ns_InitializationApi.h>
#include <nn/ns/ns_ApiForDfc.h>
#include <nn/ns/ns_SystemUpdateApi.h>
#include <nn/ns/ns_SystemUpdateSystemApi.h>
#include <nn/settings/fwdbg/settings_SettingsGetterApi.h>
#include <nn/settings/fwdbg/settings_SettingsSetterApi.h>
#include <nn/updater/updater.h>
#include <nn/updater/updater_DebugApi.h>
#include "DevKitUpdater.h"

using namespace nn;


void SystemUpdate::Prepare()
{
    ns::Initialize();
}

nn::Result SystemUpdate::SetExFatFlagsEnable()
{
    // notify-exfat-required 相当処理
    DEVKITUPDATER_LOG("set notify-exfat-required\n");
    UPDATER_RESULT_DO(ns::NotifyExFatDriverRequired());

    // notify-exfat-downloaded 相当処理
    DEVKITUPDATER_LOG("set notify-exfat-downloaded flag\n");
    UPDATER_RESULT_DO(ns::NotifyExFatDriverDownloaded());

    return nn::ResultSuccess();
}

nn::Result SystemUpdate::DoUpdate()
{
    ViewSetState(ViewDisplayState_Progress);
    ViewSetString("Now System Updating");

    DEVKITUPDATER_LOG("Waiting occupy system update control...\n");
    ns::SystemUpdateControl control;
    {
        // Stopwatch s;
        UPDATER_RESULT_DO(control.Occupy());
    }

    NN_ALIGNAS(4096) static char CardUpdateBuffer[os::MemoryPageSize * 1024];

    DEVKITUPDATER_LOG("Waiting setup card update...\n");
    {
        // Stopwatch s;
        // UPDATER_RESULT_DO(control.SetupCardUpdate(CardUpdateBuffer, sizeof(CardUpdateBuffer)));
        nn::Result result = control.SetupCardUpdateViaSystemUpdater(CardUpdateBuffer, sizeof(CardUpdateBuffer));
        if(nn::ns::ResultAlreadyUpToDate().Includes(result))
        {
            std::string errorString = "System is up to date already.\n";
            ViewErrorLog(errorString);
            NN_LOG(errorString.c_str());
            return result;
        }
        UPDATER_RESULT_DO(result);
    }

    DEVKITUPDATER_LOG("Waiting prepare card update...\n");
    {
        // Stopwatch s;

        ns::AsyncResult asyncResult;
        UPDATER_RESULT_DO(control.RequestPrepareCardUpdate(&asyncResult));
        while (!asyncResult.TryWait())
        {
            // TODO: (可能であれば)GUIにプログレスを表示する
            auto progress = control.GetPrepareCardUpdateProgress();
            DEVKITUPDATER_LOG("%12lld / %lld\n", progress.loaded, progress.total);

            os::SleepThread(TimeSpan::FromSeconds(1));
        }
        UPDATER_RESULT_DO(asyncResult.Get());
    }

    DEVKITUPDATER_LOG("Waiting apply card update...\n");
    {
        // Stopwatch s;
        control.ApplyCardUpdate();
    }

    NN_RESULT_SUCCESS;
}
