﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <nn/nn_Log.h>
#include <nn/nn_Macro.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
// #include <nn/ncm/ncm_ContentMetaId.h>
#include "DevKitUpdater_SystemUpdate.h"
#include "DevKitUpdater_View.h"

#define USE_MALLOC

// enum ResultState {
//     SUCCESS,
//     FAILURE,
// };

#define DEVKITUPDATER_LOG(...) NN_LOG(__VA_ARGS__)

#define ERROR_LOG(fmt, ...) NN_LOG(fmt, __VA_ARGS__)
#define ERROR_S(x)          ERROR_LOG("%s", x)

#define CUTFILEPATH(path)   (std::strrchr(path, '\\') ? std::strrchr(path, '\\') + 1 : path)

// #define RETURN_IF_FAILED(rslt)      {::nn::Result rst = rslt;if(!rst.IsSuccess()){NN_LOG("error: %08x (%s:%d)\n",rst.GetInnerValueForDebug(),CUTFILEPATH(__FILE__),__LINE__);result = rst;return rst;}else{result = rst;}}
// #define QUIT_IF_FAILED(rslt)        result = rslt;if(!result.IsSuccess()){NN_LOG("error: %08x (%s:%d)\n",result.GetInnerValueForDebug(),CUTFILEPATH(__FILE__),__LINE__);goto quit;}

#define LOG_IF_FALED(rslt)          { \
                                        ::nn::Result rst0 = rslt; \
                                        if(!rst0.IsSuccess()) \
                                        { \
                                            char errorString[64]; \
                                            std::memset(errorString, 0, sizeof(errorString)); \
                                            snprintf(errorString, sizeof(errorString), "error: %08x (%s:%d)\n",rst0.GetInnerValueForDebug(),CUTFILEPATH(__FILE__),__LINE__); \
                                            NN_LOG(errorString); \
                                            ViewErrorLog(errorString); \
                                        } \
                                    }
#define UPDATER_RESULT_DO(rslt)     { \
                                        ::nn::Result rst = rslt; LOG_IF_FALED(rst); \
                                        NN_RESULT_DO(rst); \
                                    }

#define SET_AND_CHECK_ALLCATION(variable, addr)       {variable = addr;if(variable == nullptr){ERROR_S("Heap allocation FAILED.\n");return ResultApplicationError();}}
#define SET_AND_CHECK_ALLCATION_QUIT(variable, addr)  {variable = addr;if(variable == nullptr){ERROR_S("Heap allocation FAILED.\n");goto quit;}}

NN_DEFINE_ERROR_RANGE_RESULT(ResultApplicationError, 500, 1, 2);
NN_DEFINE_ERROR_RANGE_RESULT(ResultNotFound, 500, 2, 3);


::nn::Result InitilizeHeap();
void FinalizeHeap();

bool CheckTargetInfomation(bool isBootFormPc);
